// $Id: BasicDocument.m,v 1.6 2002/08/24 19:08:19 hns Exp $
//
//  CocoaBasicDocument.m
//  CocoaBasic
//
//  Created by Dr. H. Nikolaus Schaller on Sat Jun 15 2002.
//  Copyright (c) 2001 __MyCompanyName__. All rights reserved.
//

#import "BasicDocument.h"
#import "BasicApplication.h"	// for preferences
// plugin interfaces
// #import "IconFamily.h"
#import <HNSAppKit/HNSBasicCompiler.h>
#import <HNSAppKit/HNSCocoaScript.h>

#include <objc/objc-class.h>
#include <objc/objc-runtime.h>
#include <objc/Protocol.h>

@interface NSDictionary (PrivateExtensions)
- (NSString *) uniqueKey:(NSString *)s;
@end

@implementation NSDictionary (PrivateExtensions)

- (NSString *) uniqueKey:(NSString *)s
{
	int i;
	NSString *n;
	if([self objectForKey:s] == nil)
		return s;	// does not yet exist
#if 0
	NSLog(@"name exists");
#endif
	for(i=1; ; i++)
		{ // try other suffixes
		n=[s stringByAppendingFormat:@"%d", i];
		if([self objectForKey:n] == nil)
			return n;	// empty slot found
		}
}

@end

@interface BasicDocument (PrivateExtensions)

- (BOOL) isValidClassIdentifier:(NSString *) s;		// valid class name (alphanum, "%_$", no blanks)
- (BOOL) isValidPropertyIdentifier:(NSString *) s;	// variable, class or instance method (alphanum, "_", no blanks, methods begin with "+-", and have ":" as well)
- (BOOL) isInstanceVariable:(NSString *) name;		// is variable (may be invalid!)
- (BOOL) isClassMethod:(NSString *) name;			// is class method (begins with "+")
- (BOOL) isInstanceMethod:(NSString *) name;		// is instance method (begins with "-")
- (BOOL) isMethod:(NSString *) name;				// is method (begins with "+-")
- (BOOL) isValidInstanceIdentifier:(NSString *) s;	// valid instance name (alphanum)
- (BOOL) isValidGroupIdentifier:(NSString *) s;		// valid NIB filename (any except " /:", may not begin with "~")

- (BOOL) isSubclass:(NSString *) c ofClass:(NSString *) s;	// check if c is a subclass of s

- (BOOL) property:(NSString *) name isDefinedInClass:(NSString *) cls;	// check if porperty exists in that class

// handle changes of objects

- (NSString *) makeSubClassOf:(NSString *) class;
- (NSString *) makeNewClass:(NSString *) name forClass:(NSString *) superclass;
- (NSString *) makeNewInstance:(NSString *) name forClass:(NSString *) name;
- (NSString *) makeNewInstanceForClass:(NSString *) class;
- (NSString *) makeNewProperty:(NSString *) property forClass:(NSString *) class withType:(NSString *) t withArgs:(NSString *) a;

- (void) saveClass:(id) Sender;
- (void) saveProperty:(id) Sender;
- (void) saveInstance:(id) Sender;

- (void) showClass;
- (void) showProperty;
- (void) showInstance;

- (void) selectClass:(NSString *) name;
- (void) selectProperty:(NSString *) name;
- (void) selectInstance:(NSString *) name;

// notification handlers
// - (void) tableChange:(NSNotification *)n;	// call reloadData

// get OBJC class into Dictionary format
- (void) extractIvars:(Class) class into:(NSMutableDictionary *) properties;
- (void) extractMethods:(Class) class type:(NSString *) type into:(NSMutableDictionary *) properties;					
- (NSDictionary *) extractClass:(Class) class returnName:(NSString **) name;

// other
- (void) nimp;	// not yet implemented

// compilation
- (NSString *) appPath;						// get application path as defined by app-settings
- (NSDictionary *) InfoPlist;				// get info.plist as defined by app-settings
- (void) compileApp;						// compile all (changed) source codes
- (void) writeNibFilesTo:(NSString *) dir;	// write instances into nibfiles
- (void) writeApp:(NSString *) dest;		// write application bundle (assuming everything is compiled)

@end

@implementation BasicDocument

- (void) nimp
{
	NSRunAlertPanel(@"CocoaBasic", @"%@", @"OK", nil, nil, @"Function not yet implemented");
}

- (NSString *) extractType:(NSScanner *) ts
{ // convert encoded type
	if([ts scanString:@"v" intoString:nil])
		return @"";	// void result
	if([ts scanString:@"i" intoString:nil])
		return @"Integer";	// int result
	if([ts scanString:@"c" intoString:nil])
		return @"Boolean";	// char result
	if([ts scanString:@"f" intoString:nil])
		return @"Single";	// float result
	if([ts scanString:@"d" intoString:nil])
		return @"Double";	// double result
	if([ts scanString:@"@" intoString:nil])
		{
		NSString *type;
		if(![ts scanString:@"\"" intoString:nil])
			return @"Object";
		[ts scanUpToString:@"\"" intoString:&type];	// class is specified
		return type;
		}
	if([ts scanString:@"#" intoString:nil])
		return @"Class";	// Class
	if([ts scanString:@"{" intoString:nil])
		{ // struct
		NSString *name;
		[ts scanUpToString:@"=" intoString:&name];	// struct name
		while(![ts isAtEnd] && ![ts scanString:@"}" intoString:nil])
			[self extractType:ts];	// component types
		return [@"Struct" stringByAppendingFormat:@" %@", name];	// Class
		}
	if([ts scanString:@"[" intoString:nil])
		{ // array
		int size;
		[ts scanInt:&size];
		[ts scanString:@"]" intoString:nil];	// should follow
		return [[self extractType:ts] stringByAppendingFormat:@"(%d)", size];
		}
	if(![ts isAtEnd])
		[ts setScanLocation:[ts scanLocation]+1];	// prevent loop
	return [ts string];	// can't decode
}

- (void) extractIvars:(Class) c into:(NSMutableDictionary *) properties
{
	int i;
	if(c->ivars)
		{ // copy instance variables
		for(i=0; i<c->ivars->ivar_count; i++)	// all instance variables
			{
			NSMutableDictionary *ivar=[NSMutableDictionary dictionaryWithCapacity:5];	// new variable record
			NSString *ivarname=[NSString stringWithCString:c->ivars->ivar_list[i].ivar_name];
#if 0
			NSLog(@" %s AS %s", c->ivars->ivar_list[i].ivar_name, c->ivars->ivar_list[i].ivar_type);
#endif
			[ivar setObject:[self extractType:[NSScanner scannerWithString:[NSString stringWithCString:c->ivars->ivar_list[i].ivar_type]]] forKey:Content_Class_Property_type];
//			[ivar setObject:[NSNumber numberWithInt:2] forKey:Content_Class_Property_inherited];	// locally defined
			[properties setObject:ivar forKey:ivarname];	// create new variable entry
			}
		}
}

- (void) extractMethods:(Class) c forType:(NSString *) mtype into:(NSMutableDictionary *) properties // type is @"+" or @"-"
{
	void *iterator=NULL;
	int i;
	struct objc_method_list *mlist;
	while(mlist=class_nextMethodList(c, &iterator))
		{
		for(i=0; i<mlist->method_count; i++)	// all methods
			{
			NSString *mname=NSStringFromSelector(mlist->method_list[i].method_name);		// method name
			NSMutableDictionary *method=[NSMutableDictionary dictionaryWithCapacity:5];		// new method record
			NSScanner *ts=[NSScanner scannerWithString:[NSString stringWithCString:mlist->method_list[i].method_types]];
			[method setObject:@"builtin-category" forKey:Content_Class_Method_category];
//			[method setObject:[NSNumber numberWithInt:2] forKey:Content_Class_Property_inherited];	// locally defined
			[method setObject:[self extractType:ts] forKey:Content_Class_Property_type];
			[method setObject:[ts string] forKey:Content_Class_Method_args];
			// may define other entries...
			[properties setObject:method forKey:[mtype stringByAppendingString:mname]];	// create new method entry
			}
		}
}

- (NSDictionary *) extractProtocols:(Class) c
{
	NSMutableDictionary *protocols=[NSMutableDictionary dictionaryWithCapacity:10];		// document entry for protocols
	int i;
	if(c->protocols != NULL)
		{
		for(i=0; i<c->protocols->count; i++)
			{
			Protocol *p=c->protocols->list[i];
			NSString *pname=[NSString stringWithCString:[p name]];		// protocol name
			[protocols setObject:@"exists" forKey:pname];		// make entry
			}
		}
#if 1
	NSLog(@"%@", protocols);
#endif
	return protocols;
}

- (NSDictionary *) extractClass:(Class) c returnName:(NSString **) name
{ // get OBJC Class into Dictionary format
	NSMutableDictionary *class=[NSMutableDictionary dictionaryWithCapacity:10];		// document entry for this class
	NSMutableDictionary *properties;
	if(name != NULL)
		*name=[NSString stringWithCString:object_getClassName(c)];	// extract class name
	if(c->super_class != Nil)
		{
		NSString *sc=[NSString stringWithCString:object_getClassName(c->super_class)];
		[class setObject:sc forKey:Content_Class_Superclass];
		}
	[class setObject:[[[[NSBundle bundleForClass:c] bundlePath] lastPathComponent] stringByDeletingPathExtension] forKey:Content_Class_Type];
#if 0
	[class setObject:[NSNumber numberWithInt:c->version] forKey:Content_Class_Version];
	[class setObject:[NSNumber numberWithInt:c->info] forKey:Content_Class_Info];
	[class setObject:[NSNumber numberWithInt:c->size] forKey:Content_Class_Size];
#endif
	[class setObject:(properties=[NSMutableDictionary dictionaryWithCapacity:10]) forKey:Content_Class_Properties];
	[self extractIvars:c into:properties];
	[self extractMethods:c forType:@"-" into:properties];
	[self extractMethods:(c->isa) forType:@"+" into:properties];
	return class;
}

- (void) loadSystemClasses
{ // load system classes and add them to the current document
	Class *AllClasses=NULL;
	NSEnumerator *enumerator;
	NSString *key;
	int numClasses=0;
	int newNumClasses=objc_getClassList(NULL, 0);
	int j;
#if 0
	NSLog(@"loadSystemClasses");
#endif
	while(numClasses < newNumClasses)
		{ // not enough
		numClasses = newNumClasses;
		AllClasses = realloc(AllClasses, sizeof(Class) * numClasses);
		newNumClasses = objc_getClassList(AllClasses, numClasses);
		}
	if(AllClasses != NULL)
		{ // copy to content:Classes
		for(j=0; j<numClasses; j++)
			{
			NSString *cname;
			NSDictionary *c=[self extractClass:AllClasses[j] returnName:&cname];
			[classes setObject:c forKey:cname];	// store (should better merge!)
			}
		}
#if 0
	NSLog(@"%d classes loaded to %08x", numClasses, AllClasses);
#endif
	free(AllClasses);
	// process superclasses, i.e. addinherited properties
	enumerator=[classes keyEnumerator];
	while(key=[enumerator nextObject])
		{
		NSString *sc=[[classes objectForKey:key] objectForKey:Content_Class_Superclass];
		NSDictionary *sd;
		if(sc)
			{ // has superclass
			NSEnumerator *penumerator;
			NSString *pkey;
			sd=[classes objectForKey:sc];	// superclass should exist as well
			if(sd)
				{
				penumerator=[[sd objectForKey:Content_Class_Properties] keyEnumerator];	// walk through superclass properties
				while(pkey=[penumerator nextObject])
					{ // property of superclass
					NSMutableDictionary *cp;	// class property dictionary
					cp=[[classes objectForKey:key] objectForKey:Content_Class_Properties];
					if([cp objectForKey:pkey] == nil)
						{ // property exists in superclass -> copy
				//		NSLog(@"class=%@ superclass=%@ property=%@ add", key, sc, pkey);
						[cp setObject:[[sd objectForKey:Content_Class_Properties] objectForKey:pkey] forKey:pkey];	// copy property from superclass
						}
//					[[cp objectForKey:pkey] setObject:@"true" forKey:Content_Class_Property_inherited];
					}
				}
			}
		}
}

- (id) init
{
#if 0
	NSLog(@"[BasicDocument init]");
#endif
	self=[super init];
	if(self)
		{
		// create structure
		content=[[NSMutableDictionary dictionaryWithCapacity:4] retain];
		[content setObject:settings=[NSMutableDictionary dictionaryWithCapacity:20] forKey:Content_AppSettings];
		[settings setObject:[NSMutableArray arrayWithCapacity:5] forKey:Content_AppSettings_FileTypes];
		[content setObject:[NSMutableDictionary dictionaryWithCapacity:700] forKey:Content_Classes];
		[content setObject:[NSMutableDictionary dictionaryWithCapacity:5] forKey:Content_Instances];
		[content setObject:[NSMutableArray arrayWithCapacity:5] forKey:Content_Resources];
		[content setObject:[NSMutableDictionary dictionaryWithCapacity:20] forKey:Content_Icons];
		[content setObject:[NSMutableDictionary dictionaryWithCapacity:5] forKey:Content_Sounds];
		[content setObject:[NSMutableDictionary dictionaryWithCapacity:5] forKey:Content_HelpFiles];
		[content setObject:[NSMutableDictionary dictionaryWithCapacity:20] forKey:Content_Strings];
		[self setContentPointers];	// get direct access pointers
		// set application defaults
		[settings setObject:@"myapp" forKey:Content_AppSettings_Name];	// default name
		[settings setObject:@"myapp 1.0a1" forKey:Content_AppSettings_AppVersion];
		[settings setObject:@"com.mycompany.myapp" forKey:Content_AppSettings_BndlID];
		[settings setObject:@"1.0a1" forKey:Content_AppSettings_BndlVersion];
		[settings setObject:@"my??" forKey:Content_AppSettings_Creator];
		[settings setObject:@"NSApplication" forKey:Content_AppSettings_MainClass];
//		[settings setObject:@"English" forKey:Content_AppSettings_Language];
		[settings setObject:@"1.0a1" forKey:Content_AppSettings_ShortVersion];

		[helpfiles setObject:@"Help for myapp" forKey:Content_NameOf_MainHelpFile];
		
		{ // do some test initialization
			NSMutableDictionary *f=[[NSMutableDictionary alloc] init];
			[f setObject:@"any" forKey:Content_FileTypes_name];
			[f setObject:[NSArray arrayWithObjects:@"*", nil] forKey:Content_FileTypes_extensions];
			[f setObject:[NSArray arrayWithObjects:@"****", nil] forKey:Content_FileTypes_ostypes];
			[f setObject:@"viewer" forKey:Content_FileTypes_role];
			[ftypes addObject:f];
		}
#if 1
		{ // do some more test initialization
			NSMutableDictionary *f=[[NSMutableDictionary alloc] init];
			[f setObject:@"JPEG Image" forKey:Content_FileTypes_name];
			[f setObject:[NSArray arrayWithObjects:@".jpg", nil] forKey:Content_FileTypes_extensions];
			[f setObject:[NSArray arrayWithObjects:@"JPEG", nil] forKey:Content_FileTypes_ostypes];
			[f setObject:@"viewer" forKey:Content_FileTypes_role];
			[ftypes addObject:f];
		}
		{ // do some additonal test initialization
			NSMutableDictionary *f=[[NSMutableDictionary alloc] init];
			[f setObject:@"TIFF Image" forKey:Content_FileTypes_name];
			[f setObject:[NSArray arrayWithObjects:@".tif", @".tiff", nil] forKey:Content_FileTypes_extensions];
			[f setObject:[NSArray arrayWithObjects:@"TIF ", nil] forKey:Content_FileTypes_ostypes];
			[f setObject:@"viewer" forKey:Content_FileTypes_role];
			[ftypes addObject:f];
		}
		{ // do some test initialization
			NSMutableDictionary *f=[[NSMutableDictionary alloc] init];
			[f setObject:@"some.plist" forKey:Content_Resources_Name];
			[f setObject:Content_Resources_Type_Std forKey:Content_Resources_Type];
			[f setObject:@"/Users/test/Resources/some.plist" forKey:Content_Resources_Location];
			[resources addObject:f];
		}
		{ // do some test initialization
			NSMutableDictionary *f=[[NSMutableDictionary alloc] init];
			[f setObject:@"plugin.bundle" forKey:Content_Resources_Name];
			[f setObject:Content_Resources_Type_Plugin forKey:Content_Resources_Type];
			[f setObject:@"" forKey:Content_Resources_Location];
			[resources addObject:f];
		}
#endif
		[self loadSystemClasses];	// load system classes
		[self makeNewInstance:@"MainMenu" forClass:@"NSMenu"];	// first menu instance
		[self makeNewInstance:@"MainWindow" forClass:@"NSWindow"];	// first window instance
		[self makeNewInstance:@"AppDelegate" forClass:@"NSObject"];	// first window instance
				// rename to Content_NameOf_MainInstance?
		    {
				NSMenuItem *sender=[[[NSMenuItem alloc] initWithTitle:@"internal"
												action:@selector(newApplicationSubclass:)
												keyEquivalent:@""] autorelease];
				[self newApplicationSubclass:sender];
				// should better make a fresh Delegate to NSApplication!
			}
		}
	editedClassNeedsSaving=NO;
	editedPropertyNeedsSaving=NO;
	editedInstanceNeedsSaving=NO;
	appSettingsNeedsSaving=NO;
	[self updateChangeCount:NSChangeCleared];
	return self;
}

- (void) setContentPointers
{
	[self setContentPointers:@"English"];
}

- (void) setContentPointers:(NSString *) language
{ // for faster access
	// handle language variants
	classes=[content objectForKey:Content_Classes];
	instances=[content objectForKey:Content_Instances];
	resources=[content objectForKey:Content_Resources];
	settings=[content objectForKey:Content_AppSettings];
	ftypes=[settings objectForKey:Content_AppSettings_FileTypes];
	strings=[content objectForKey:Content_Strings];
	icons=[content objectForKey:Content_Icons];
	sounds=[content objectForKey:Content_Sounds];
	helpfiles=[content objectForKey:Content_HelpFiles];
}

- (void) dealloc
{
	[allClassKeys release];
	[allInstanceKeys release];
	[allPropertyKeys release];
	[content release];		// release all memory
	[super dealloc];
}

// NIB interface

- (NSString *)windowNibName
{	// Implement this to return a nib to load OR implement -makeWindowControllers to manually create your controllers.
#if 0
    NSLog(@"[BasicDocument windowNibName]");
#endif
	return @"CocoaBasic";
}

#if 0
- (void)makeWindowControllers
{
#if 0
	NSLog(@"[BasicDocument makeWindowControllers] controller=%@\n", controller);
#endif
	return nil;
}
#endif

- (void)windowControllerDidLoadNib:(NSWindowController *) aController
{
#if 0
	NSLog(@"[BasicDocument windowControllerDidLoadNib]\n");
#endif
    [super windowControllerDidLoadNib:aController];
    // Add any code here that need to be executed once the windowController has loaded the document's window.
}

- (void) awakeFromNib
{
	NSComboBoxCell *c=[[[NSComboBoxCell alloc] init] autorelease];
	[c setItemHeight:10.0];
	[c setCompletes:YES];
	[c setBordered:NO];
	[c setControlSize:NSSmallControlSize];
	[c setUsesDataSource:YES];
	[c setDataSource:self];	// call numberOfItemsInComboBox etc.
	[[classlist tableColumnWithIdentifier:@"superclass"] setDataCell:c];
#if 0
	NSLog(@"[BasicDocument awakeFromNib]");
#endif
	[classlist setDoubleAction:@selector(tableDoubleClick:)];
	[instancelist setDoubleAction:@selector(tableDoubleClick:)];
	[propertylist setDoubleAction:@selector(tableDoubleClick:)];
	[valuelist setDoubleAction:@selector(tableDoubleClick:)];
	[filetypelist setDoubleAction:@selector(tableDoubleClick:)];
#if 0
	[[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(tableChange:) name:StackChangedNotification object:callstack];
	[[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(tableChange:) name:ClassListChangedNotification object:classlist];
	[[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(tableChange:) name:InstanceListChangedNotification object:instancelist];
#endif
	
	[codeeditor setKeywordResourceFile:[[NSBundle mainBundle] pathForResource:@"Keywords" ofType:@"plist"]];
	[codeeditor autoHighlight:YES];
#if 1
	[codeeditor setString:@"function this(a as integer, b as string, c as object) as something\nif a=5 then\nmsgbox b\nend if\nend function"];
	[codeeditor setSelectedRange:NSMakeRange(3, 11)];
	[codeeditor highlightSyntax];
#endif
}

- (BOOL)keepBackupFile
{
	return getPreference(Preferences_keepBackup, bool);
}

- (BOOL)readFromFile:(NSString *)fileName ofType:(NSString *)docType
{
	NSMutableDictionary *n;
	NSLog(@"read from file: %@ (%@)", fileName, docType);
	if(![docType isEqualToString:@"CocoaBasic"])
		/* return NO; */;
	n=[NSMutableDictionary dictionaryWithContentsOfFile:fileName];	// read
	if(!n || ![n objectForKey:Content_Classes] || ![n objectForKey:Content_Instances] || ![n objectForKey:Content_AppSettings])
		return NO; // does not have required structure
	[content autorelease];	// replace current
	content=[n retain];
	[self setContentPointers];
	[self loadSystemClasses];
	return YES;
}

- (BOOL)writeToFile:(NSString *)fileName ofType:(NSString *)docType
{
	NSMutableDictionary *wc;
	NSEnumerator *enumerator;
	NSString *key;
#if 1
	NSLog(@"write to file: %@ (%@)", fileName, docType);
#endif
	[self saveClass:self];	// save any changes first
	if(![docType isEqualToString:@"CocoaBasic"])
		return NO;
	wc=[[content mutableCopy] autorelease];	// make a working copy of all classes
	NS_DURING	// set up exception handler!
	[wc setObject:[[[wc objectForKey:Content_Classes] mutableCopy] autorelease] forKey:Content_Classes];	// make a copy of all classes
	enumerator=[[wc objectForKey:Content_Classes] keyEnumerator];
	while((key=[enumerator nextObject]))
		{ // remove all classes that are not Content_Class_Type_UserDefined
		NSMutableDictionary *class=[[wc objectForKey:Content_Classes] objectForKey:key];	// class record
		NSEnumerator *penumerator;
		NSString *prop;	// current property
		[class setObject:[[[class objectForKey:Content_Class_Properties] mutableCopy] autorelease] forKey:Content_Class_Properties];	// make a copy of all properties
		[key retain];	// must retain as removeObjectForKey:key will dealloc!
		penumerator=[[class objectForKey:Content_Class_Properties] keyEnumerator];
		while((prop=[penumerator nextObject]))
			{ // scan all methods and Ivars
			NSMutableDictionary *p=[[class objectForKey:Content_Class_Properties] objectForKey:prop];	// property record
			[prop retain];
#if 0
			if([key retainCount] <= 0)	NSLog(@"key %@ retain=%d", key, [key retainCount]);
			if([prop retainCount] <= 0)	NSLog(@"prop %@ retain=%d", prop, [prop retainCount]);
			if([p retainCount] <= 0)	NSLog(@"p %@ retain=%d", p, [p retainCount]);
#endif
			if([self isMethod:prop])
				{ // method
				if([p objectForKey:Content_Class_Method_source] == nil)
					{ // no local source available
#if 0
					if(f)
						{
						NSLog(@"remove method %@.%@ = %@", key, prop, [[class objectForKey:Content_Class_Properties] objectForKey:prop]);
						NSLog(@"retainCount: key %d prop %d class.properties %d class.properties(method) %d",
			[key retainCount], [prop retainCount], [[class objectForKey:Content_Class_Properties] retainCount], [[[class objectForKey:Content_Class_Properties] objectForKey:prop] retainCount]);
						}
#endif
					[[class objectForKey:Content_Class_Properties] removeObjectForKey:prop];	// is not redefined
#if 0
						NSLog(@"removed method %@.%@ = %@", key, prop, [[class objectForKey:Content_Class_Properties] objectForKey:prop]);
#endif
					}
				else
					{
#if 1
					NSLog(@"keep method %@.%@", key, prop);
#endif
					}
				}
			else
				{ // variable
				//// must use other method to distinguish user defined variables from system!!!!!
				if(1 || [self property:prop isDefinedInClass:[class objectForKey:Content_Class_Superclass]])
					{ // is inherited from superclass
#if 0
						NSLog(@"remove Ivar %@.%@", key, prop);
#endif
					[[class objectForKey:Content_Class_Properties] removeObjectForKey:prop];	// is inherited
					}
				else
					{
#if 1
					NSLog(@"keep Ivar %@.%@ not defined in class %@", key, prop, [class objectForKey:Content_Class_Superclass]);
#endif
					}
				}
			[prop release];
			}
		if(![[class objectForKey:Content_Class_Type] isEqualToString:Content_Class_Type_UserDefined] &&
	        [[class objectForKey:Content_Class_Properties] count] == 0)
			{ // all properties have been removed - remove class as well but keep user classes
#if 0
			NSLog(@"remove class %@ retain=%d", key, [key retainCount]);
			if([key isEqualToString:@"NSToolTipPanel"])
				NSLog(@"tooltippanel structure %@", [[wc objectForKey:Content_Classes] objectForKey:key]);
#endif				
			[[wc objectForKey:Content_Classes] removeObjectForKey:key];	// don't write class at all
#if 0
			NSLog(@"removed class %@ retain=%d", key, [key retainCount]);
#endif
			}
		[key release];
		}
	NS_HANDLER
		{ // exception
		NSRunAlertPanel(@"Fatal internal error", @"%@: %@", @"OK", nil, nil, [localException name], localException);
		return NO;
		}
	NS_ENDHANDLER
#if 1
	NSLog(@"%@", wc);
#endif
	return [wc writeToFile:fileName atomically:YES];	// write working copy in XML
}

- (void) touch
{
	NSLog(@"touch");
	[self updateChangeCount:NSChangeDone];
}

// management of tables

- (int)numberOfItemsInComboBoxCell:(NSComboBoxCell *)aComboBoxCell
{
	return [classes count];
}

- (id)comboBoxCell:(NSComboBoxCell *)aComboBoxCell objectValueForItemAtIndex:(int)index
{
	return [[classes allKeys] objectAtIndex:index];
}

// data source [TableView dataSource]

- (int)numberOfRowsInTableView:(NSTableView *)aTableView
{
	// NSLog(@"numberOfRowsInTableView\n");
	if(objectcode == nil)
		return 0;	// not yet awaked
	if(aTableView == classlist)
		{
		int filter=[[classfilter selectedItem] tag];
		NSMutableArray *a=[NSMutableArray arrayWithCapacity:[classes count]];	// get all keys for faster access
		NSEnumerator *e;
		NSString *key;
		[allClassKeys release];
		e=[classes keyEnumerator];
		while(key=[e nextObject])
			{ // check filter criteria
			int attrib=2;	// 1=application, 2=plugin, 4=system
			NSString *type=[[classes objectForKey:key] objectForKey:Content_Class_Type];
			if([type isEqualToString:@"KeyManager"] || [type isEqualToString:@"About"])
				attrib=0;	// DISABLED
			else if([type isEqualToString:@"AppKit"] || [type isEqualToString:@"Foundation"] || [type isEqualToString:@"CocoaBasic"] || [type isEqualToString:@"lib"])
				attrib=4;	// builtin
			else if([type isEqualToString:Content_Class_Type_UserDefined])
				attrib=1;	// user defined
			if((filter & attrib) != 0)
				[a addObject:key];	// pass filter
			}
		allClassKeys=[a retain];	// get all keys for faster access
#if 0
		NSLog(@"classes count=%d allClassKeys count=%d", [classes count], [allClassKeys count]);
#endif
		return [allClassKeys count];	// number of rows
		}
	if(aTableView == propertylist)
		{ // cache all properties of current class
		NSDictionary *p=[editedclass objectForKey:Content_Class_Properties];
		int filter=[[propertyfilter selectedItem] tag];
		NSMutableArray *a=[NSMutableArray arrayWithCapacity:[p count]];	// get all keys for faster access
		NSEnumerator *e;
		NSString *key;
		[allPropertyKeys release];
		e=[p keyEnumerator];
		while(key=[e nextObject])
			{ // check filter criteria
//			NSNumber *i=[[p objectForKey:key] objectForKey:Content_Class_Property_inherited];
//			int attrib=[i intValue];	// inherited vs. defined vs. overridden
			int attrib=2;	// defined
			if([self property:key isDefinedInClass:[editedclass objectForKey:Content_Class_Superclass]])
				{ // superclass is defined and same property exists there
				attrib=1;	// is inherited
				if([[p objectForKey:key] objectForKey:Content_Class_Method_source] != nil)
					attrib=4;	// is overridden (redefined)
				}
#if 0
			NSLog(@"key=%@ filter=%d inherited=%@", key, filter, i);
#endif
			if((filter & attrib) != 0)
				[a addObject:key];	// pass filter
			}
		allPropertyKeys=[a retain];	// make permanent
		return [allPropertyKeys count];
		}
	if(aTableView == instancelist)
		{
		[allInstanceKeys release];
		// could apply filter here
		allInstanceKeys=[[instances allKeys] retain];	// get all keys for faster access
		return [allInstanceKeys count];
		}
	if(aTableView == valuelist)
		{
		[allValueKeys release];
		// could apply filter here, e.g. for internal variables beginning with _
		// and filter pseudo-Variables implemented by getter&setter functions
		allValueKeys=[[[editedinstance objectForKey:Content_Instances_Ivars] allKeys] retain];	// get all keys for faster access
#if 0
		NSLog(@"[allValueKeys count]=%d", allValueKeys);
#endif
		return [allValueKeys count];
		}
	if(aTableView == filetypelist)
		return [ftypes count];
	if(aTableView == stringlist)
		return [strings count];
	if(aTableView == resourceslist)
		return [resources count];
	if(aTableView == helpfilelist)
		return [helpfiles count];
//	if(aTableView == callstack)
//		return [[self callstack] count];
	if(aTableView == objectcode)
		return [[[editedproperty objectForKey:Content_Class_Method_code] code] count];
	NSLog(@"[numberOfRowsInTableView:%@] unknown - window=%@", aTableView, [[aTableView window] title]);
	return 1;	// default
}

- (id)tableView:(NSTableView *)aTableView objectValueForTableColumn:(NSTableColumn *)aTableColumn row:(int)rowIndex
{
	NSString *col=[aTableColumn identifier];	// which column
										  // get data dependent on tableView and tableColumn
	if(aTableView == classlist)
		return [self valueInClassTable:col row:rowIndex];
	if(aTableView == propertylist)
		return [self valueInPropertyTable:col row:rowIndex];
	if(aTableView == instancelist)
		return [self valueInInstanceTable:col row:rowIndex];
	if(aTableView == valuelist)
		return [self valueInValueTable:col row:rowIndex];
	if(aTableView == filetypelist)
		return [self valueInFileTypeTable:col row:rowIndex];
	if(aTableView == resourceslist)
		return [self valueInResourcesTable:col row:rowIndex];
	// single column tables
	if(aTableView == helpfilelist)
		return [[helpfiles allKeys] objectAtIndex:rowIndex];				// get helpfile list
//	if(aTableView == callstack)
//		return [[[self callstack] objectAtIndex:rowIndex] description];		// get call stack entries
	if(aTableView == objectcode)
		return [[[[editedproperty objectForKey:Content_Class_Method_code] code] objectAtIndex:rowIndex] description];	// get compiled code
	return col;	// default: show internal column name
}

// should validate values, i.e.
// classlist:
//   classname is unchanged or unique and valid identifier name
//   superclass exists and is not class itself (avoid recursion!)
// instancelist:
//   name is unique and valid identifier name
//   class exists
//   group - not empty
// propertylist:
//   has only one + or -name and is unique

- (void)tableView:(NSTableView *)aTableView setObjectValue:(id)anObject forTableColumn:(NSTableColumn *)aTableColumn row:(int)rowIndex
{
	NSString *col=[aTableColumn identifier];	// which column
#if 1
	NSLog(@"set table[%d, %@]=%@", rowIndex, col, anObject);
#endif
	if(aTableView == classlist)
		[self setValue:anObject inClassTable:col row:rowIndex];
	else if(aTableView == instancelist)
		[self setValue:anObject inInstanceTable:col row:rowIndex];
	else if(aTableView == propertylist)
		[self setValue:anObject inPropertyTable:col row:rowIndex];
	else if(aTableView == valuelist)
		[self setValue:anObject inValueTable:col row:rowIndex];
	else
		{
		NSLog(@"tableView:setObjectValue: unknown table");
		[self nimp];
		}
}

// delegation [TableView delegate]

#if 0
- (BOOL)tableView:(NSTableView *)aTableView shouldEditTableColumn:(NSTableColumn *)aTableColumn row:(int)rowIndex
{ // enable/disable editing of individual cells
	int r;
	NSString *col=[aTableColumn identifier];	// which column
#if 0
	NSLog(@"shouldEditTableColumn:%@ row:%d", col, rowIndex);
#endif
	if(aTableView == objectcode)
		return NO;	// don't edit
	r=[(HNSSortedTableView *)aTableView table2data:rowIndex];	// is HNSSortedTableView - should become translated automatically!
	if(aTableView == helpfilelist)
		return ![[self tableView:aTableView objectValueForTableColumn:aTableColumn row:r] isEqualTo:Content_NameOf_MainHelpFile]; // disable editing of name of main help file
	if(aTableView == propertylist)	// allow editing the name only if not inherited
		return ![self property:[self valueInPropertyTable:Content_Class_Property_name row:r] isDefinedInClass:[editedclass objectForKey:Content_Class_Superclass]];
	if(aTableView == classlist)
		return [[self valueInClassTable:Content_Class_Type row:r] isEqualTo:Content_Class_Type_UserDefined];	// YES only if application defined class
	return YES;
}
#endif

- (void)tableView:(NSTableView *)aTableView willDisplayCell:(id)aCell forTableColumn:(NSTableColumn *)aTableColumn row:(int)rowIndex
{ // set special display attributes
	int r;
	NSString *col=[aTableColumn identifier];	// which column
	if(aTableView == objectcode)
		return;	// don't call table2data
	r=[(HNSSortedTableView *)aTableView table2data:rowIndex];	// is HNSSortedTableView - should become translated automatically!
	if(aTableView == propertylist)
		{ // aCell is by default a NSTextFieldCell
		if([self property:[self valueInPropertyTable:Content_Class_Property_name row:r] isDefinedInClass:[editedclass objectForKey:Content_Class_Superclass]])
			{
			if([self valueInPropertyTable:Content_Class_Method_source row:r] != nil)
				[aCell setTextColor:[NSColor darkGrayColor]];	// redefined/overridden from superclass
			else
				[aCell setTextColor:[NSColor lightGrayColor]];	// inherited from superclass
			}
		else
			[aCell setTextColor:[NSColor blackColor]];		// locally defined
		// return [[editedclass objectForKey:Content_Class_Properties] count];
		// set attributes like italics, bold, grey etc. of text cell
		return;
		}
	if(aTableView == classlist)
		{
		if([col isEqualToString:Content_Class_Superclass])
			{
	//		if([[self valueInClassTable:Content_Class_Type] isEqualToString:Content_Class_Type_UserDefined])
	//			; // make ComboBoxCell i.e. permit modifications of superclass
	  // this won't work! must use a subclass of NSTableColumn instead that overrides dataCellForRow:r
			}
		}
}

// actions [TableView target]

- (IBAction) secondClick:(HNSSortedTableView *)aTableView
{ // enable editing
	int r, c;
	r=[aTableView clickedDataRow];
	c=[aTableView clickedColumn];
#if 1
	NSLog(@"second Click (%d, %d)", r, c);
#endif
	if(aTableView == classlist)
		{
		if(![[self valueInClassTable:Content_Class_Type row:r] isEqualTo:Content_Class_Type_UserDefined])
			return;		// YES only if application defined class
		if(c == 2)
			return;		// only name or superclass may be edited
		}
	else if(aTableView == instancelist)
		{ // edit anything
		}
	else if(aTableView == propertylist)
		{ // only if not inherited
		if([self property:[self valueInPropertyTable:Content_Class_Property_name row:r] isDefinedInClass:[editedclass objectForKey:Content_Class_Superclass]])
			return;
		}
	else if(aTableView == valuelist)
		{
		if(c != 2)		// only value my be edited
			return;
		}
	[aTableView selectDataRow:r byExtendingSelection:NO];	// select (should already be but...)
	[aTableView editColumn:c dataRow:r withEvent:nil select:YES];
}

- (IBAction) tableClick:(HNSSortedTableView *)aTableView
{ // single click (i.e. selection) - clickedRow=-1 means deselection
	int r, c;
	static int lastr=-2;
	static HNSSortedTableView *lastTable=nil;
	r=[aTableView clickedDataRow];
	if(r >= 0 && [[NSApp currentEvent] clickCount] == 1 && r == lastr && aTableView == lastTable)
		{ // first click on same entry again
		[self secondClick:aTableView];
		lastTable=nil;	// needs to double click again
		return;
		}
	lastr=r;
	lastTable=aTableView;
	c=[aTableView clickedColumn];
#if 1
	NSLog(@"tableClick (%d, %d) count=%d", r, c, [[NSApp currentEvent] clickCount]);
#endif
	if(r<0)
		return;
	if(aTableView == classlist)
		[self showClass];
	else if(aTableView == instancelist)
		[self showInstance];
	else if(aTableView == filetypelist)
		return;	// ignore single clicks
	else if(aTableView == propertylist)
		[self showProperty];
	else
		{
		NSLog(@"tableClick: unknown table");
		}
}

- (IBAction) tableDoubleClick:(HNSSortedTableView *)aTableView
{ // double click (i.e. open action or something alike)
	int r, c;
	r=[aTableView clickedDataRow];
	c=[aTableView clickedColumn];
#if 1
	NSLog(@"tableDoubleClick(%d, %d)", r, c);
#endif
	if(aTableView == classlist)
		[self editClass:self];
	else
	if(aTableView == instancelist)
		[self editInstance:self];
	else
	if(aTableView == filetypelist)
		{ // edit selected entry
		if(r >= 0)
			[self editFileType:self];
		else
			[filetypeeditor performClose:self];	// abort editing
		return;
		}
	else
		NSLog(@"tableDoubleClick: unknown table");
}

#if 0
- (void) tableChange:(NSNotification *)n
{ // process table change notifications sent by interpreter
#if 1
	NSLog(@"tableChange: %@", [n name]);
#endif
	if([[n name] isEqualToString:StackChangedNotification])
		[callstack reloadData];
#if 0
	else if([[n name] isEqualToString:ClassListNotification])
		[classlist reloadData];
	else if([[n name] isEqualToString:InstanceListNotification])
		[instancelist reloadData];
#endif
}
#endif

- (BOOL) control:(NSControl *) c isValidObject:(id) obj
{ // check form contents etc.
#if 1
	NSLog(@"control:%@ isValidObject:%@", c, obj);
#endif
	if(c == classlist)
		{ // check for duplicate classes, properties
		if([obj isEqualToString:@""] /* || ![obj isvalididentifier] */)
			{
			// popup alert
			return NO;
			}
		}
	return YES;
}

// access resources

- (id) valueInResourcesTable:(NSString *)column row:(int)rowIndex
{
	return [[resources objectAtIndex:rowIndex] objectForKey:column];	// get from file types
}

// access file types

- (id) valueInFileTypeTable:(NSString *)column row:(int)rowIndex
{
	if([column isEqualToString:Content_FileTypes_extensions])
		{ // collect from array to , separated string
		return [[[ftypes objectAtIndex:rowIndex] objectForKey:column] componentsJoinedByString:@","];
		}
	if([column isEqualToString:Content_FileTypes_ostypes])
		{ // collect from array to , separated string
		return [[[ftypes objectAtIndex:rowIndex] objectForKey:column] componentsJoinedByString:@","];
		}
	return [[ftypes objectAtIndex:rowIndex] objectForKey:column];	// get from file types
}

// classes

- (NSString *) makeSubClassOf:(NSString *) superClass
{
	if([superClass hasPrefix:@"NS"] || [superClass hasPrefix:@"My"])
		return [self makeNewClass:[classes uniqueKey:[@"My" stringByAppendingString:[superClass substringFromIndex:2]]] forClass:superClass];
	return [self makeNewClass:[classes uniqueKey:[@"My" stringByAppendingString:superClass]] forClass:superClass];
}

- (NSString *) makeNewClass:(NSString *) n forClass:(NSString *) superClass
{ // create new subclass
	NSMutableDictionary *c=[NSMutableDictionary dictionaryWithCapacity:5];
	NSMutableDictionary *prop;
#if 0
	NSLog(@"%@ %d", n, [n retainCount]);
#endif
	if([superClass length] == 0 || [classes objectForKey:superClass] == nil)
		[NSException raise:@"Internal Error" format:@"makeNewClass: unknown superclass %@", superClass];
	prop=[[[classes objectForKey:superClass] objectForKey:Content_Class_Properties] mutableCopy];
	[c setObject:superClass forKey:Content_Class_Superclass];
	[c setObject:prop forKey:Content_Class_Properties];
	[c setObject:Content_Class_Type_UserDefined forKey:Content_Class_Type];
#if 0
	OBJC_EXPORT void objc_addClass(Class myClass);	// materialize within Objective C
#endif
	[classes setObject:c forKey:n];	// add to classes list
	[classlist reloadData];
	[self touch];
#if 0
	NSLog(@"makeNewClass: %@ -> %@", n, c);
#endif
	return n;
}

- (id) valueInClassTable:(NSString *)col row:(int)rowIndex
{ // use allClassKeys cache for fast (!) access to all Classes
#if 0
	NSLog(@"%@ %@", aTableColumn, col);
#endif
	NSString *name=[allClassKeys objectAtIndex:rowIndex];
	if([col isEqualToString:Content_Class_name])
		return name;
	return [[classes objectForKey:name] objectForKey:col];
}

- (void) setValue:(id)val inClassTable:(NSString *)col row:(int)rowIndex
{
	NSString *name=[allClassKeys objectAtIndex:rowIndex];
	if([col isEqualToString:Content_Class_name])
		{ // change class name
		NSEnumerator *e;
		id o;
		if([name isEqualToString:val])
			return;	// unchanged
		if(val)
			{ // already exists
			[classes setObject:[classes objectForKey:name] forKey:val];	// copy
			}
		[classes removeObjectForKey:name];	// remove old
		if(!val)
			val=@"deleted class";	// make invalid if used anywhere!
		e=[classes objectEnumerator];
		while(o=[e nextObject])
			{ // rename superclass references
			if([[o objectForKey:Content_Class_Superclass] isEqualTo:name])
				[o setObject:val forKey:Content_Class_Superclass];	// rename
			}
		e=[instances objectEnumerator];
		while(o=[e nextObject])
			{ // rename class references
			if([[o objectForKey:Content_Instances_Class] isEqualTo:name])
				[o setObject:val forKey:Content_Instances_Class];	// rename
			// rename variables ???
			}
		[instancelist reloadData];
		// rename all property types using this class
		// rename all Document File Types referring to this class
		// rename Content_AppSettings_MainClass if referring to this class
		}
	else
		{ // change column value
		[[classes objectForKey:name] setObject:val forKey:col];
		}
	[classlist reloadData];
	[self touch];
}

- (BOOL) isSubclass:(NSString *) c ofClass:(NSString *) s;	// check if c is a subclass of s
{
	NSDictionary *cl=[classes objectForKey:c];
	NSString *scl=[cl objectForKey:Content_Class_Superclass];
	if(cl == nil || scl == nil)
		return NO;	// root found
	if([scl isEqualToString:s])
		return YES;	// found!
	return [self isSubclass:scl ofClass:s];	// may be subclass of subclass of s
}

// class properties - for current editedclass

- (id) valueInPropertyTable:(NSString *)col row:(int)rowIndex
{
#if 0
	NSLog(@"%@ %@", aTableColumn, col);
#endif
	NSString *name=[allPropertyKeys objectAtIndex:rowIndex];
	if([col isEqualToString:Content_Class_Property_name])
		return name;
	return [[[editedclass objectForKey:Content_Class_Properties] objectForKey:name] objectForKey:col];
}

- (void) setValue:(id)val inPropertyTable:(NSString *)col row:(int)rowIndex
{ // change instance object value
	NSString *name=[allPropertyKeys objectAtIndex:rowIndex];
	if([col isEqualToString:Content_Class_Property_name])
		{ // rename/delete
		NSEnumerator *e;
		id o;
		if([name isEqualToString:val])
			return;	// unchanged
		if(val)
			{ // new object should still exist
	 // check that variable is not changed into method and vice versa
		// check that name does not already exist
		// check if property does not exist in any subclass (!)
			[[editedclass objectForKey:Content_Class_Properties] setObject:[[editedclass objectForKey:Content_Class_Properties] objectForKey:name] forKey:val];	// copy
			}
		[[editedclass objectForKey:Content_Class_Properties] removeObjectForKey:name];	// remove old
		e=[instances objectEnumerator];
		while(o=[e nextObject])
			{ // rename property references
			NSEnumerator *f=[[o objectForKey:Content_Instances_Ivars] keyEnumerator];
			id p;
			while(p=[f nextObject])
				{ // rename property references
				if([p isEqualTo:name])
					{
					if(val)
						[[o objectForKey:Content_Instances_Ivars] setObject:[[o objectForKey:Content_Instances_Ivars] objectForKey:name] forKey:val];	// rename
					[[o objectForKey:Content_Instances_Ivars] removeObjectForKey:name];	// remove
					}
				}
			}
		}
	else
		{
		if(val)
			[[[editedclass objectForKey:Content_Class_Properties] objectForKey:name] setObject:val forKey:col];
		else
			[[[editedclass objectForKey:Content_Class_Properties] objectForKey:name] removeObjectForKey:col];
		}
	[self touch];
	[valuelist reloadData];		// may be visible and may be influenced by this class/property
	[propertylist reloadData];
}

- (NSString *) makeNewProperty:(NSString *) name forClass:(NSString *) class withType:(NSString *) t withArgs:(NSString *) a
{ // create new property for given class
	NSString *n=[[[classes objectForKey:class] objectForKey:Content_Class_Properties] uniqueKey:name];	// make unique name
	NSMutableDictionary *p=[NSMutableDictionary dictionaryWithCapacity:5];
	[p setObject:@"protected" forKey:Content_Class_Property_access];
	[p setObject:t forKey:Content_Class_Property_type];	// initial type
	if(a)
		[p setObject:a forKey:Content_Class_Method_args];	// method arguments
#if 1
	NSLog(@"makeNewProperty:%@ forClass:%@ -> %@ %@", name, class, n, p);
#endif
	[[editedclass objectForKey:Content_Class_Properties] setObject:p forKey:n];	// add new property to editedclass
	[propertylist reloadData];			// may be visible
	// add to all subclasses and subsub classes!
	if([self isInstanceVariable:n])
		{ // add to list of instance variables of all instances with that class
		NSEnumerator *e=[instances objectEnumerator];
		NSMutableDictionary *o;	// instance record
		while(o=[e nextObject])
			{ // all instances
			if([[o objectForKey:Content_Instances_Class] isEqualToString:class])
				{
				NSMutableDictionary *ivar=[NSMutableDictionary dictionaryWithCapacity:2];
				[ivar setObject:[[class copy] autorelease] forKey:Content_Instances_Ivar_type];
				[ivar setObject:/*[NSNull null]*/ @"" forKey:Content_Instances_Ivar_value];
				[[o objectForKey:Content_Instances_Ivars] setObject:ivar forKey:n];	// add ivar record
				}
			}
		[valuelist reloadData];	// may be visible
		}
#if 1
	NSLog(@"makeNewProperty: %@", n);
#endif
	[self touch];
	return n;
}

// instances

- (NSString *) makeNewInstanceForClass:(NSString *) class
{ // use derived name
	NSString *name;
	if([classes objectForKey:class] == nil)
		{ // should not happen!
		NSLog(@"undefined class: %@", class);
		return @"";
		}
	if([class hasPrefix:@"NS"])
		name=[class substringFromIndex:2];		// use class name by removing NS
	else if([class hasPrefix:@"My"])
		name=[class substringFromIndex:2];		// use class name by removing My
	else if([class hasPrefix:@"Basic"])
		name=[class substringFromIndex:5];		// use class name by removing Basic
	else
		name=@"Instance";	// or ClassInstance?
	return [self makeNewInstance:name forClass:class];
}

- (NSString *) makeNewInstance:(NSString *) name forClass:(NSString *) class
{ // create new instance of given class
	NSString *n=[instances uniqueKey:name];	// make unique name
	NSMutableDictionary *instance=[NSMutableDictionary dictionaryWithCapacity:3];
	NSMutableDictionary *ivars=[NSMutableDictionary dictionaryWithCapacity:20];
	NSDictionary *classp=[[classes objectForKey:class] objectForKey:Content_Class_Properties];
	NSEnumerator *e=[classp keyEnumerator];
	NSString *key;
	[instance setObject:class forKey:Content_Instances_Class];	// instance class
	while(key=[e nextObject])
		{ // copy all class properties to ivars and set default values or NSNull
		if([self isInstanceVariable:key])
			{ // add to this instance
			NSMutableDictionary *ivar=[NSMutableDictionary dictionaryWithCapacity:2];
			[ivar setObject:[[classp objectForKey:key] objectForKey:Content_Class_Property_type] forKey:Content_Instances_Ivar_type];
			[ivar setObject:/*[NSNull null]*/@"" forKey:Content_Instances_Ivar_value];
			[ivars setObject:ivar forKey:key];	// add ivar record
			}
		}
	[instance setObject:ivars forKey:Content_Instances_Ivars];
	[instance setObject:Content_NameOf_MainInstance forKey:Content_Instances_Group];	// add to main group
	[instances setObject:instance forKey:n];	// add to instances
	[instancelist reloadData];
#if 0
	NSLog(@"makeNewInstance: %@", n);
#endif
	[self touch];
	return n;
}

- (id) valueInInstanceTable:(NSString *)col row:(int)rowIndex
{
	NSString *name=[allInstanceKeys objectAtIndex:rowIndex];
	if([col isEqualToString:Content_Instances_name])
		return name;
	return [[instances objectForKey:name] objectForKey:col];
}

- (void) setValue:(id)val inInstanceTable:(NSString *)col row:(int)rowIndex
{
	NSString *name=[allInstanceKeys objectAtIndex:rowIndex];
	if([col isEqualToString:Content_Instances_name])
		{ // change instance name
		if([name isEqualToString:val])
			return;	// unchanged
		if(val)
			[instances setObject:[instances objectForKey:name] forKey:val];	// copy
		[instances removeObjectForKey:name];	// remove old
		}
	else if([col isEqualToString:Content_Instances_Class])
		{ // change class
	// needs to update properties
		[self nimp];
		}
	else if([col isEqualToString:Content_Instances_Group])
		{ // change instance name
		[[instances objectForKey:name] setObject:val forKey:col];
		}
	[instancelist reloadData];
	[self touch];
}

// instance values

- (id) valueInValueTable:(NSString *)col row:(int)rowIndex
{
#if 0
	NSLog(@"%@ %@", aTableColumn, col);
#endif
	NSString *name=[allValueKeys objectAtIndex:rowIndex];
	if([col isEqualToString:Content_Instances_Ivar_name])
		return name;
	if([col isEqualToString:Content_Instances_Ivar_type])
		{ // get class of current instance and find property with same name
		NSDictionary *clsprops=[[classes objectForKey:[editedinstance objectForKey:Content_Instances_Class]] objectForKey:Content_Class_Properties];
		NSDictionary *prop=[clsprops objectForKey:name];
		if(prop == nil)
			prop=[clsprops objectForKey:[@"-" stringByAppendingString:name]]; // try return type of getter method
		if(prop == nil)
			return @"unknown property";
		return [prop objectForKey:Content_Class_Property_type];	// type of defining property
		}
	return [[[editedinstance objectForKey:Content_Instances_Ivars] objectForKey:name] objectForKey:col];
}

- (void) setValue:(id)val inValueTable:(NSString *)col row:(int)rowIndex
{ // change instance object value
	NSString *name=[allInstanceKeys objectAtIndex:rowIndex];
	if([col isEqualToString:Content_Instances_Ivar_name])
		{
		NSLog(@"can't change name of property in instance editor");
		}
	if([col isEqualToString:Content_Instances_Ivar_type])
		{
		NSLog(@"can't change class of property in instance editor");
		}
	[[[editedinstance objectForKey:Content_Instances_Ivars] objectForKey:name] setObject:val forKey:col];
	[valuelist reloadData];	// has been changed
	[self touch];
}

//

- (IBAction) import:(id)Sender
{ // should ask for file and merge
	NSOpenPanel *o=[NSOpenPanel openPanel];
	[o setAllowsMultipleSelection:YES];
	[o setCanChooseDirectories:YES];	// e.g. nib files
	[o setCanChooseFiles:YES];
	[o setResolvesAliases:YES];
	if([o runModalForTypes:nil] == NSCancelButton)
		return;	// ignore
		// handle import of NIB files
#if 0
	NSLog(@"import");
#endif
	[self nimp];
}

- (IBAction) export:(id)Sender
{
	NSLog(@"export");
	// should be specific object to export
	[self nimp];
}

//
// debugging
//

- (NSArray *) callstack
{ // get call stack
	if(!debugapp)
		return nil;
#if 0
	// remote access stack object
	return [debugapp callStack];	// may return nil if not launched
#endif
	return nil;
}

- (IBAction) openDebugger:(id) Sender
{
	[debugger orderFront:Sender];	// show debugger window
}

- (void) terminated:(NSNotification *) n
{
#if 1
	NSLog(@"terminated");
#endif
	if([debugapp terminationStatus] != 0)
		NSRunAlertPanel(@"Debugger", @"Application terminated with status=%d", @"OK", nil, nil, [debugapp terminationStatus]);
	[debugapp release];
	debugapp=nil;
}

- (void) launch
{
	if(getPreference(Preferences_showDebugRun, bool))
		[debugger orderFront:self];	// show debugger window
	if(debugapp == nil)
		{ // compile to temporary application
		NSString *dest=[[NSTemporaryDirectory() stringByAppendingPathComponent:[[NSProcessInfo processInfo] globallyUniqueString]] stringByAppendingPathExtension:@"app"];
		NSBundle *b;
		NS_DURING	// set up exception handler!
			compiler=NSClassFromString(@"BasicCompiler");
			if(compiler == nil)
				[NSException raise:@"Build Error" format:@"Compiler plugin is not available"];
			[self compileApp];
			[self writeApp:dest];
			b=[NSBundle bundleWithPath:dest];
			if(b == nil)
				[NSException raise:@"Internal Error" format:@"Bundle %@ can't be accessed (disk full?)", dest];
#if 1
			NSLog(@"Launching application %@, %@", b, [b executablePath]);
#endif
			debugapp=[[[NSTask alloc] init] retain];
			[debugapp setCurrentDirectoryPath:dest];	// run within bundle (?)
			[debugapp setLaunchPath:[b executablePath]];	// must launch cocoa application executable like finder !?!
			stopped=NO;
			// set up distributed object access to access stack and single stepping
			[[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(terminated:) name:NSTaskDidTerminateNotification object:debugapp];	// add myself as task termination observer
			[debugapp launch];
		NS_HANDLER
			{ // exception, i.e. syntax error or alike
	 //			[sourcecode setSelectedRange:NSMakeRange([compiler errorPos], 0)];	// show scanner location
				NSRunAlertPanel([localException name], @"%@", @"OK", nil, nil, localException);
				return;	// don't launch, i.e. keep debugapp=nil
			}
		NS_ENDHANDLER
		}
}

- (IBAction) run:(id) Sender
{
	if(debugapp != nil && stopped)
		{ // resume after stop
		stopped=NO;	// no longer stopped
		[debugapp resume];
		return;
		}
	if(getPreference(Preferences_saveBeforeRun, bool))
		[[NSDocumentController sharedDocumentController] saveAllDocuments:Sender];
	[self launch];
}

- (IBAction) stopapp:(id) Sender
{
#if 1
	NSLog(@"stopapp");
#endif
	[debugapp suspend];
	stopped=YES;
}

- (IBAction) kill:(id) Sender
{ // try to terminate by SIGTERM
#if 1
	NSLog(@"kill");
#endif
	[debugapp terminate];
}

- (IBAction) interrupt:(id) Sender
{ // try to terminate by SIGINT
#if 1
	NSLog(@"interrupt");
#endif
	[debugapp interrupt];
}

- (IBAction) stepIn:(id) Sender
{
	// make it step
	// by using distributed object access to runtime interpreter
	// [debugapp step];	// execute next line
}

- (IBAction) step:(id) Sender
{
	// get current level
	do
		[self stepIn:Sender];
	while(0);	// while higher stack level
}

- (IBAction) stepOut:(id) Sender
{
	// get current function level
	do
		[self stepIn:Sender];
	while(0);	// while within this function
}

// write application

- (NSString *) appPath;
{ // get application path
	NSString *path;
	// check application type - if bundle/plugin -> always relative to project file
	if(getPreference(Preferences_compileApplic, bool))
		path=[NSHomeDirectory() stringByAppendingPathComponent:@"Applications"];	// to Applications folder
	else
		{
		if([self fileName] == nil)
			[NSException raise:@"Build Error" format:@"Application destination undefined"]; // project has not yet been saved
		path=[[self fileName] stringByDeletingLastPathComponent];
		}
	return [path stringByAppendingPathComponent:[settings objectForKey:Content_AppSettings_Name]];
}

- (NSDictionary *) InfoPlist
{ // make Info.plist
	NSMutableDictionary *i=[settings mutableCopy];			// make a copy of the basic settings incl. file types
	// merge contents from Runtime.app
	// add fixed parts
	[i setObject:getPreference(Preferences_devLang, string) forKey:InfoPlist_DevelopmentRegion];	// default help file
	[i setObject:[Content_NameOf_MainHelpFile stringByAppendingPathExtension:@"help"] forKey:InfoPlist_HelpFile];	// default help file
	[i setObject:[Content_NameOf_MainIconFile stringByAppendingPathExtension:@"icns"] forKey:InfoPlist_IconFile];	// application Icon
	[i setObject:Content_NameOf_Executable forKey:InfoPlist_Executable];	// location of executable
	[i setObject:[NSString stringWithFormat:@"%@ %@", [settings objectForKey:Content_AppSettings_Name], [settings objectForKey:Content_AppSettings_ShortVersion]] forKey:InfoPlist_GetInfoString];	// compose GetInfo String
	[i setObject:[Content_NameOf_MainInstance stringByAppendingPathExtension:@"nib"] forKey:InfoPlist_MainNIB];	// main Instance group
	return i;
}

- (void) compileApp						// compile all source codes
{
	NSEnumerator *enumerator;
	NSString *key;
	enumerator=[classes keyEnumerator];
	while((key=[enumerator nextObject]))
		{
		NSMutableDictionary *class=[classes objectForKey:key];	// class record
		NSEnumerator *penumerator=[[class objectForKey:Content_Class_Properties] keyEnumerator];
		NSString *prop;	// current property
		while((prop=[penumerator nextObject]))
			{ // scan all methods and Ivars
			NSMutableDictionary *p=[[class objectForKey:Content_Class_Properties] objectForKey:prop];	// property record
			if([self isMethod:prop])
				{ // is a method
				NSString *src=[p objectForKey:Content_Class_Method_source];
				if(src && ![p objectForKey:Content_Class_Method_code])
					{ // needs compilation
					NSString *icode;
#if 0
					NSLog(@"compiling %@.%@", key, prop);
#endif
					// show in progress window
					icode=[compiler compile:src];	// compile
					[p setObject:icode forKey:Content_Class_Method_icode];
					// and compile script
					// [p setObject:[CocoaScript compile:icode] forKey:Content_Class_Method_code];
					}
				}
			}
		}
}

- (void) writeNibFilesTo:(NSString *) dir
{ // write NIB-Files to directory
	NSMutableDictionary *names=[NSMutableDictionary dictionaryWithCapacity:10];
	NSFileManager *m=[NSFileManager defaultManager];
	NSEnumerator *enumerator;
	NSString *key;
#if 1
	NSLog(@"write NIB Files to %@", dir);
#endif
	enumerator=[instances keyEnumerator];
	while((key=[enumerator nextObject]))
		{ // get group for this instance
		// should better store Array of Instances for this Group, i.e. directly generate new index
		NSString *nib=[[instances objectForKey:key] objectForKey:Content_Instances_Group];
		NSMutableArray *o=[names objectForKey:nib];
		if(o == nil)
			{ // new NIB file
			o=[NSMutableArray arrayWithCapacity:10];
			[names setObject:o forKey:nib];
			}
		[o addObject:[instances objectForKey:key]];
		}
	enumerator=[names keyEnumerator];
	while((key=[enumerator nextObject]))
		{ // create this NIB-File
		NSString *nf=[[dir stringByAppendingPathComponent:key] stringByAppendingPathExtension:@"nib"];
		NSMutableDictionary *cls=[NSMutableDictionary dictionaryWithCapacity:2];
		NSMutableArray *ibclasses=[NSMutableArray arrayWithCapacity:10];
#if 0
		NSLog(@"write %@", nf);
#endif
		if(![m createDirectoryAtPath:nf attributes:nil])
			[NSException raise:@"Build Error" format:@"Can't create NIB bundle %@", nf];
		// classes.nib (Property List)
		//   ROOT
		// 	   IBVersion	1
		//     IBClasses = Array of Dictionary
		//       ACTIONS Dictionary (name, @"id")
		//       CLASS String
		//       LANGUAGE ObjC
		//       OUTLETS Dictionary (name, class)
		//       SUPERCLASS String
		[cls setObject:@"1" forKey:@"IBVersion"];
		// for all classes
		{
			NSMutableDictionary *class=[NSMutableDictionary dictionaryWithCapacity:2];
		//	[class setObject:dictionary of actions forKey:@"ACTIONS"];
			[class setObject:@"classname" forKey:@"CLASS"];
			[class setObject:@"ObjC" forKey:@"LANGUAGE"];
			//	[class setObject:dictionary of outlets forKey:@"OUTLETS"];
			[class setObject:@"classname" forKey:@"SUPERCLASS"];
			[ibclasses addObject:class];	// add
		}
		[cls setObject:ibclasses forKey:@"IBClasses"];
		if(![cls writeToFile:[nf stringByAppendingPathComponent:@"classes.nib"] atomically:NO])
			[NSException raise:@"Build Error" format:@"Can't write %@", [nf stringByAppendingPathComponent:@"classes.nib"]];
		//
		// info.nib (not written - contains window positions etc.)
		//
		// objects.nib (typedstream)
		//
		//   encode to dir/name.nib/name.nib
		}
}

- (void) writeApp:(NSString *) dest	// write application (assuming everything is compiled)
{
	NSFileManager *m=[NSFileManager defaultManager];	// to handle files
	Class ifc=NSClassFromString(@"IconFamily");			// should have been loaded as a plugin
	NSString *suffix=@"app";							// default suffix
	NSEnumerator *enumerator;							// to walk through classes etc.
	NSString *key;		// key into classes
	NSString *e;		// temporary filename
	NSBundle *b;		// new bundle
	NSDictionary *ipl;	// Info.plist
	int i;
	//
	// preparation
	//
#if 1
	NSLog(@"writeApp: %@", dest);
#endif
	if(dest == nil)
		[NSException raise:@"Build Error" format:@"Application destination undefined"];
	// check application type - if bundle/plugin -> define proper suffix and template
	if(![[dest pathExtension] isEqualToString:suffix])
		dest=[dest stringByAppendingPathExtension:suffix];	// append
	//
	// copy template to new bundle
	//
	if([suffix isEqualToString:@"app"])
		{ // copy application template
		NSString *rt=[[NSBundle mainBundle] pathForResource:@"RunTime" ofType:@"app"];
		if(rt == nil)
			[NSException raise:@"Build Error" format:@"Runtime application is missing"];
		[m removeFileAtPath:dest handler:nil];	// remove before copying
		if(![m copyPath:rt toPath:dest handler:nil])	// create empty application from RunTime Framework
			[NSException raise:@"Build Error" format:@"Can't copy Runtime application from %@ to %@", rt, dest];
		}
	else
		{
		[NSException raise:@"Build Error" format:@"writing %@ not yet supported", suffix];
		}
	b=[NSBundle bundleWithPath:dest];	// access new bundle
	//
	// write Info.plist
	//
	e=[[b resourcePath] stringByDeletingLastPathComponent];
	e=[[e stringByAppendingPathComponent:@"Info"] stringByAppendingPathExtension:@"plist"];
	ipl=[self InfoPlist];
	if(![ipl writeToFile:e atomically:YES])
		[NSException raise:@"Build Error" format:@"Can't write Info.plist to %@", e];
	//
	// copy all plugins installed in CocoaBasic
	// may try to optimize if these classes are never used (but what about NSClassFromString() ?)
	// should NOT copy BasicCompiler by default!!!
	//
	if(![m copyPath:[[NSBundle mainBundle] builtInPlugInsPath] toPath:[b builtInPlugInsPath] handler:nil]) // copy all plugins of CocoaBasic into new application
		; // [NSException raise:@"Build Error" format:@"Can't copy resource from %@ to %@", [r objectForKey:Content_Resources_Location], d];
	//
	// copy user-defined Resources and Plugins
	//
	for(i=[resources count]-1; i>=0; i--)
		{ // copy Resources & PlugIns from project
		NSDictionary *r=[resources objectAtIndex:i];
		NSString *t=[r objectForKey:Content_Resources_Type];
		NSString *d=[b resourcePath];	// standard resource
		if(![t isEqualToString:Content_Resources_Type_Std])
			{
			if([t isEqualToString:Content_Resources_Type_Plugin])
				d=[b builtInPlugInsPath];	// plugin resource
			else
				[NSException raise:@"Build Error" format:@"invalid resource destination type %@", t];
			}
		d=[d stringByAppendingPathComponent:[r objectForKey:Content_Resources_Name]];	// add resource name
		if(![[r objectForKey:Content_Resources_Location] isEqualToString:@""])
			{ // copy from source to desitination
			if(![m copyPath:[r objectForKey:Content_Resources_Location] toPath:dest handler:nil])
				; // [NSException raise:@"Build Error" format:@"Can't copy resource from %@ to %@", [r objectForKey:Content_Resources_Location], d];
			}
			else
			{ // write out file wrapper [r objectForKey:Content_Resources_Value]
				NSLog(@"write file wraper %@", [r objectForKey:Content_Resources_Value]);
			}
		}
	//
	// write Application Icon
	//
	if(ifc != nil)
		{ // insert icon
		NSImage *img=[[[NSImage alloc] initWithData:[settings objectForKey:Content_AppSettings_Icon]] autorelease];
		if(img == nil)
			img=[NSImage imageNamed:@"NSApplicationIcon"];	// replace by default icon
#if 0
		NSLog(@"image=%@", img);
#endif
		if(img != nil)
			{ // exists
			id i=[ifc iconFamilyWithThumbnailsOfImage:img];
			NSString *iconfile=[[b resourcePath] stringByAppendingPathComponent:[ipl objectForKey:InfoPlist_IconFile]];
#if 0
			NSLog(@"i=%@ iconfile=%@", img, iconfile);
#endif
			if(![i writeToFile:iconfile])
				[NSException raise:@"Build Error" format:@"Could not write Icon to %@", iconfile];
			}
		}
	else
		{ // alert that plugin is missing
		NSRunAlertPanel(@"Internal Error", @"%@", @"OK", nil, nil, @"Plugin 'IconFamily' is missing. Application Icon not changed.");
		}
	//
	// insert help file
	//

	//
	// write all compiled code
	//
	enumerator=[classes keyEnumerator];
	while((key=[enumerator nextObject]))
		{ // store all code in single array and write encoded to Resources/CocoaScript.code
		NSMutableDictionary *class=[classes objectForKey:key];	// class record
		NSEnumerator *penumerator = [[class objectForKey:Content_Class_Properties] keyEnumerator];
		NSString *prop;	// current property
		BOOL keep=NO;
		while((prop=[penumerator nextObject]))
			{ // scan all methods and Ivars
//			NSMutableDictionary *p=[[class objectForKey:Content_Class_Properties] objectForKey:prop];	// property record
#if 0
			NSLog(@"%@.%@", key, prop);
#endif
			if([self isMethod:prop])
				{ // method
					{
#if 0
					NSLog(@"%@.%@ - redefined Method", key, prop);
#endif
					keep=YES;	// locally defined method
					}
				}
			else
				{ // variable
#if 0
				NSLog(@"%@.%@ - Ivar", key, prop);
#endif
					{
#if 0
					NSLog(@"%@.%@ - redefined Ivar", key, prop);
#endif
					keep=YES;	// locally defined instance variable
					}
				}
			}
		}
	[@"type:=5; NSWindow alloc init;"
       writeToFile:[[[b resourcePath] stringByAppendingPathComponent:@"CocoaScript"] stringByAppendingPathExtension:@"code"] atomically:NO];	// write code
	//
	// write NIB-Files
	//
	[self writeNibFilesTo:[b resourcePath]];
}

// menu and user interface validation

- (void)textDidChange:(NSNotification *)aNotification
{ // source code did change
	id o=[aNotification object];
#if 1
	NSLog(@"textDidChange: %@", o);
#endif
	editedPropertyNeedsSaving=YES;
	[editedproperty removeObjectForKey:Content_Class_Method_icode];	// remove intermediate code
	[editedproperty removeObjectForKey:Content_Class_Method_code];	// remove compiled code
	[self touch];
}

- (void)controlTextDidChange:(NSNotification *)aNotification
{ // class name, etc. did change
	id o=[aNotification object];
#if 0
	NSLog(@"controlTextDidChange: %@", aNotification);
	NSLog(@"object: %@ classname: %@ controlView: %@", o, classname, [classname controlView]);
#endif
#if 0
	if(o == [classname controlView])
		{
#if 1
		NSLog(@"editedClassNeedsSaving");
#endif
		editedClassNeedsSaving=YES;
		[self touch];
		}
	else
#endif
	if(o == [typename controlView] || o == [methodname controlView] || o == [methodargs controlView])
		{
#if 1
		NSLog(@"editedPropertysNeedsSaving");
#endif
		editedPropertyNeedsSaving=YES;
		[self touch];
		}
	if(o == [appname controlView] ||
	   o == [appcreator controlView] ||
	   o == [appversion controlView] ||
	   o == [shortversion controlView] ||
	   o == [bundleid controlView] ||
	   o == [bundleversion controlView])
		{
#if 1
		NSLog(@"appSettingsNeedsSaving");
#endif
		appSettingsNeedsSaving=YES; // don't touch here, user may cancel...
		}
}

- (BOOL) validateMenuItem:(id <NSMenuItem>) item
{
	SEL sel=[item action];	// check on action - so that the title can be changed
#if 0
	NSLog(@"BasicDocument validateMenuItem %@ %@", [item title], NSStringFromSelector([item action]));
#endif
	// File Menu
	if(sel == @selector(newClass:))
		return [classlist selectedRow] >= 0;	// any class selected
	if(sel == @selector(newDocumentSubclass:) || sel == @selector(newViewSubclass:))
		return YES;	// always enabled
	if(sel == @selector(newInstance:))
		return [classlist selectedRow] >= 0;	// any class selected
	if(sel == @selector(newWindow:) || sel == @selector(newMenu:))
		return YES;	// always enabled
	if(sel == @selector(export:))
		return NO;	// disable
	// Edit Menu
	if(sel == @selector(newMethod:) || sel == @selector(newVariable:) ||
	   sel == @selector(newOutlet:) || sel == @selector(newAction:))
		return editedclass != nil;	// some class is being edited
	if(sel == @selector(editClass:))
		return [classlist selectedRow] >= 0;	// any class selected
	if(sel == @selector(editInstance:))
		return [instancelist selectedRow] >= 0;	// any instance selected
	if(sel == @selector(editWindow:))
		return [instancelist selectedRow] >= 0 && NO;	// any instance selected and is subclass of NSMenu or NSWindow
	if(sel == @selector(editMenu:))
		return [instancelist selectedRow] >= 0 && NO;	// any instance selected and is subclass of NSMenu or NSWindow
//	if(sel == @selector(editProperty:))
//		return editedclass != nil && editedproperty != nil;
	if(sel == @selector(editCode:))
		return editedclass != nil;	// some class is being edited
	if(sel == @selector(deleteClass:))
		return [classlist selectedRow] >= 0 /* && Bundle==Application */;	// any Application Class selected
	if(sel == @selector(deleteInstance:))
		return [instancelist selectedRow] >= 0;	// any instance selected
	if(sel == @selector(deleteProperty:))
		return editedclass != nil && editedproperty != nil /* && deletion permitted */;	// class is open and property can be deleted
	if(sel == @selector(duplicateClass:))
		return [classlist selectedRow] >= 0;	// any class selected
	if(sel == @selector(duplicateInstance:))
		return [instancelist selectedRow] >= 0;	// any instance selected
	if(sel == @selector(duplicateProperty:))
		return editedclass != nil && editedproperty != nil;	// class is open and property is selected
	// Debug Menu
	if(sel == @selector(run:))
		return debugapp == nil || stopped;	// if not (yet) running or stopped
	if(sel == @selector(kill:) || sel == @selector(interrupt:))
		return debugapp != nil;	// debugging session is active
	if(sel == @selector(step:) || sel == @selector(stepIn:) || sel == @selector(stepOut:))
		return debugapp != nil && ![debugapp isRunning];	// debugging session is active and currently not running
	if(sel == @selector(stopapp:))
		return debugapp != nil && [debugapp isRunning] && !stopped;		// debugging session is active and running
	if(sel == @selector(compileSource:))
		return editedclass != nil && editedproperty != nil /* && and source exists */;
	return [super validateMenuItem:item];	// default
}

#if 0
- (BOOL)validateUserInterfaceItem:(id <NSValidatedUserInterfaceItem>)item
{
#if 1
	NSLog(@"BasicDocument validateUserInterfaceItem %@ %@", [item title], NSStringFromSelector([item action]));
#endif
	return [super validateUserInterfaceItem:item];	// default
}
#endif

// compiler control

////// somehow handle progress window (if required!)

- (void) saveAppSettings:(id)Sender
{
	if(appSettingsNeedsSaving)
		{ // has been changed
		[settings setObject:[appname objectValue] forKey:Content_AppSettings_Name];
		[settings setObject:[appcreator objectValue] forKey:Content_AppSettings_Creator];
		if([appiconview image] != nil)
			{ // store application icon as compressed JPEG
			NSData *data=[NSBitmapImageRep
                representationOfImageRepsInArray:[[appiconview image] representations]
				usingType:NSJPEGFileType 	// store as JPEG
				properties:[NSDictionary
                         dictionaryWithObjectsAndKeys:[NSDecimalNumber numberWithFloat:1.0],
						NSImageCompressionFactor, nil]];
			[settings setObject:data forKey:Content_AppSettings_Icon];
#if 1
			NSLog(@"icon data size: %ld", [data length]);
#endif
			}
		//	[settings setObject:[applanguage objectValue] forKey:Content_AppSettings_Language];
		[settings setObject:[appversion objectValue] forKey:Content_AppSettings_AppVersion];
		[settings setObject:[shortversion objectValue] forKey:Content_AppSettings_ShortVersion];
		[settings setObject:[bundleid objectValue] forKey:Content_AppSettings_BndlID];
		[settings setObject:[bundleversion objectValue] forKey:Content_AppSettings_BndlVersion];
		[settings setObject:[defaultwindow objectValue] forKey:Content_AppSettings_MainClass];
		appSettingsNeedsSaving=NO;
		[self touch];	// needs to save document
		}
}

- (IBAction) buildOk:(id)Sender
{
	NSString *aname=[appname objectValue];
	NSString *dest;
#if 0
	NSLog(@"Build Ok\n");
#endif
	[self saveAppSettings:Sender];
	if([[appbuild title] isEqualToString:@"Build"])
		{
		if([aname isEqualToString:@""] || [aname isEqualToString:@"myapp"])
			{ // appname is not (properly) defined
			if(NSRunAlertPanel(@"Warning", @"Application name is not set properly (i.e. empty or 'myapp')", @"Continue", @"Cancel", nil, nil) == 0)
				{ // is cancelled
				// [appsettings performClose:self];		// close if (still) open
				return;
				}
			}
		[appsettings performClose:self];		// close if (still) open
#if 0
		NSLog(@"Build Application\n");
#endif
		compiler=NSClassFromString(@"HNSBasicCompiler");
		if(compiler == nil)
			[NSException raise:@"Build Error" format:@"Compiler plugin is not available"];
		NS_DURING	// set up exception handler!
			[self compileApp];
			dest=[self appPath];
			[self writeApp:dest];
			//
            // show result in Finder
            //
			[[NSWorkspace sharedWorkspace] noteFileSystemChanged:dest];
			if(getPreference(Preferences_showApplic, bool))
				[[NSWorkspace sharedWorkspace] openFile:dest withApplication:@"Finder"];	// show in Finder
  // alternative:
  //	- (BOOL)selectFile:(NSString *)fullPath inFileViewerRootedAtPath:(NSString *)rootFullPath
  // Selects the file specified by fullPath. If a path is specified by rootFullPath, a new file viewer is opened.
  // If rootFullPath is an empty string (@""), the file is selected in the main viewer.
  // Returns YES if the file is successfully selected, NO otherwise.
			NS_HANDLER
			{ // exception, i.e. syntax error or alike
//			[sourcecode setSelectedRange:NSMakeRange([compiler errorPos], 0)];	// show scanner location
			NSRunAlertPanel([localException name], @"%@", @"OK", nil, nil, localException);
			}
		NS_ENDHANDLER
		return;
		}
	[appsettings performClose:self];		// close if (still) open
}

- (IBAction) chooseIcon:(id)Sender;
{
	NSOpenPanel *o=[NSOpenPanel openPanel];
	NSImage *i;
	[o setAllowsMultipleSelection:NO];
	[o setCanChooseDirectories:NO];
	[o setCanChooseFiles:YES];
	[o setResolvesAliases:YES];
	if([o runModalForTypes:nil] == NSCancelButton)
		return;	// ignore
	i=[[[NSImage alloc] initWithContentsOfFile:[[o filenames] objectAtIndex:0]] autorelease];	// try first one
	if(i == nil)
		{
		NSRunAlertPanel(@"Error", @"Can't open file %@", @"OK", nil, nil, [[o filenames] objectAtIndex:0]);
		return;
		}
	[appiconview setImage:i];
	appSettingsNeedsSaving=YES;
}

- (IBAction) changeAppSettings:(id)Sender;
{
#if 1
	NSLog(@"changeAppSettings\n");
#endif
	appSettingsNeedsSaving=YES;
}

- (IBAction) buildApplication:(id)Sender
{ // open build application
#if 0
	NSLog(@"buildApplication\n");
#endif
	if(getPreference(Preferences_confirmSettings, bool))
		{
		[self appSettings:Sender];		// show settings
		[appbuild setTitle:@"Build"];	// but change button ---- should be localizable!!!
		return;
		}
	[self buildOk:Sender];	// directly call build without confirmation
}

- (IBAction) appSettings:(id)Sender
{ // open app settings
	NSImage *i;
#if 0
	NSLog(@"appSettings\n");
#endif
	[self saveClass:Sender];	// save before compiling
	[appname setObjectValue:[settings objectForKey:Content_AppSettings_Name]];
	[appcreator setObjectValue:[settings objectForKey:Content_AppSettings_Creator]];
	i=[[[NSImage alloc] initWithData:[settings objectForKey:Content_AppSettings_Icon]] autorelease];
	if(i != nil)
		[appiconview setImage:i];
//	[applanguage setObjectValue:[settings objectForKey:Content_AppSettings_Language]];
	[appversion setObjectValue:[settings objectForKey:Content_AppSettings_AppVersion]];
	[shortversion setObjectValue:[settings objectForKey:Content_AppSettings_ShortVersion]];
	[bundleid setObjectValue:[settings objectForKey:Content_AppSettings_BndlID]];
	[bundleversion setObjectValue:[settings objectForKey:Content_AppSettings_BndlVersion]];
	[defaultwindow setObjectValue:[settings objectForKey:Content_AppSettings_MainClass]];
	[appsettings orderFront:self];	// but don't make key window
	[appbuild setTitle:@"Set"];		// define button: should be localizable
}

// file types

- (IBAction) openFiletypes:(id) Sender
{
	[filetypes orderFront:Sender];
}

- (IBAction) editFileType:(id) Sender
{ // copy selected entry
	int rowIndex=[filetypelist selectedDataRow];
	if(rowIndex < 0)
		return;		// ignore
	[filetypename setObjectValue:[self valueInFileTypeTable:Content_FileTypes_name row:rowIndex]];	// copy from selection list
	[filetypeeditor makeKeyAndOrderFront:Sender];
}

- (IBAction) newFileType:(id) Sender
{
	// clear entry
	[filetypeeditor makeKeyAndOrderFront:Sender];
}

- (IBAction) saveFileType:(id) Sender
{
	// verify that name is unique and not ""
	// if everything is ok:
	// update entry
	[filetypeeditor performClose:Sender];
}

- (IBAction) deleteFileType:(id) Sender
{
	// ask for confirmation and
 // delete entry
		[self nimp];
}

// helpfile

- (IBAction) openHelpfile:(id) Sender
{
//	[helpeditortext setString:[[content objectForKey:Content_AppSettings] objectForKey:Content_AppSettings_HelpFile]];
	[helpeditor orderFront:Sender];
}

- (IBAction) saveHelp:(id) Sender
{
#if 0
	NSLog(@"saveHelp");
#endif
//	[[content objectForKey:Content_AppSettings] setObject:[helpeditortext string] forKey:Content_AppSettings_HelpFile];
	[helpeditor performClose:Sender];
}

- (BOOL) writeHelpTo:(NSString *) directory
{
	NSEnumerator *enumerator=[helpfiles keyEnumerator];
	NSString *key;
	while((key=[enumerator nextObject]))
		{
		NSString *file=[[directory stringByAppendingPathComponent:key] stringByAppendingPathExtension:@"help"];
		if(![[helpfiles objectForKey:key] writeToFile:file atomically:NO])
			{
			NSRunAlertPanel(@"System Error", @"Can't create help file in temp directory: %@", @"OK", nil, nil, file);
//			NSLog(@"can't create help file in temp directory: %@", file);
			return NO;
			}
		}
	return YES;
}

- (IBAction) previewHelp:(id) Sender
{ // preview in Help viewer
	NSString *path=[NSTemporaryDirectory() stringByAppendingPathComponent:[[NSProcessInfo processInfo] globallyUniqueString]];
//	path=[path stringByAppendingPathExtension:@"help"];	// not required
#if 0
	NSLog(@"%@", path);
#endif
#if 0	// should be unique!
	if(![[NSFileManager defaultManager] removeFileAtPath:path handler:nil])
		{
		NSLog(@"can't remove temp help directory: %@", path);
		return;
		}
#endif
	if(![[NSFileManager defaultManager] createDirectoryAtPath:path attributes:nil])
		{
		NSRunAlertPanel(@"System Error", @"Can't create temp directory: %@", @"OK", nil, nil, path);
//		NSLog(@"can't create temp help directory: %@", path);
		return;
		}
	if(![self writeHelpTo:path])
		return;
	[[NSWorkspace sharedWorkspace] openFile:[[path stringByAppendingPathComponent:Content_NameOf_MainHelpFile] stringByAppendingPathExtension:@"help"]/* withApplication:@"Edit"*/];
}

- (IBAction) importHelp:(id) Sender
{ // import HTML file or folder
	NSOpenPanel *op;
	op=[NSOpenPanel openPanel];	// get shared panel
	[op setAllowsMultipleSelection:YES];
	[op setCanChooseDirectories:YES];
	[op setCanChooseFiles:YES];
	[op setResolvesAliases:YES];
	if([op runModalForTypes:nil] != NSOKButton)	// import anything
		return;	// cancelled
	NSLog(@"import help files: %@", [op filenames]);
	// process filenames - if directory: recursively import entries
	[self nimp];
}

- (IBAction) newHelp:(id) Sender
{ // create new help file
	[helpfiles setObject:@"" forKey:[helpfiles uniqueKey:@"Help"]];
	[helpfilelist reloadData];
}

- (IBAction) deleteHelp:(id) Sender
{ // delete help file
	int r=[helpfilelist selectedDataRow];
	if(r >= 0)
		{
// don't delete or rename Content_MainHelpFile
		[self nimp];
		// confirm
		}
}

// strings

- (IBAction) openStrings:(id) Sender
{
	[stringeditor orderFront:Sender];
}

- (IBAction) saveStrings:(id) Sender
{ // save changes done in the String editor
		[self nimp];
}

// resources

- (IBAction) openResources:(id) Sender
{
	[resourcesWindow orderFront:Sender];
}

// renaming a string should go to ALL local language dictionaries

- (IBAction) newString:(id) Sender
{ // create new String
	[strings setObject:@"Localized String" forKey:[strings uniqueKey:@"String"]];
	// add to ALL local language dictionaries
	[stringlist reloadData];
}

- (IBAction) deleteString:(id) Sender
{ // delete String
		[self nimp];
}

// classes

- (IBAction) newClass:(id) Sender
{
	NSString *class;
	SEL s=[Sender action];
#if 0
	NSLog(@"new Class");
#endif
	if(s == @selector(newDocumentSubclass:))
		class=@"NSDocument";
	else if(s == @selector(newApplicationSubclass:))
		class=@"NSApplication";
	else if(s == @selector(newObjectSubclass:))
		class=@"NSObject";
	else if(s == @selector(newViewSubclass:))
		class=@"NSView";
	else
		{
		if([classlist selectedRow] < 0)
			return;	// nothing selected
		class=[self valueInClassTable:Content_Class_name row:[classlist selectedDataRow]];
		}
	[self selectClass:[self makeSubClassOf:class]];
	// if(s == @selector(newDocumentSubclass:))
	// make default entry to file types list
	[classeditor makeKeyAndOrderFront:self];
}

- (IBAction) newApplicationSubclass:(id)Sender
{ // subclass of class NSApplication
	[self newClass:Sender];
}

- (IBAction) newDocumentSubclass:(id)Sender;
{ // subclass of class NSDocument
	[self newClass:Sender];
}

- (IBAction) newViewSubclass:(id)Sender
{ // subclass of class NSView
	[self newClass:Sender];
}

- (IBAction) newObjectSubclass:(id)Sender
{
	[self newClass:Sender];
}

- (IBAction) filterClass:(id) Sender
{ // classfilter changed
#if 0
	NSLog(@"filterClass");
#endif
	[classlist reloadData];	// simply reload
}

- (void) saveClass:(id) Sender
{ // save class
	[self saveProperty:Sender];		// do changes in properties first
	if(editedClassNeedsSaving)
		{ // copy back
#if 0
		NSLog(@"saveClass: %@", [classname stringValue]);
#endif
		// there is not much to copy back...
		editedClassNeedsSaving=NO;	// done
		}
}

- (void) showClass
{ // show currently selected class in class editor
	int rowIndex=[classlist selectedDataRow];
	NSString *c;
	[self saveClass:self];	// save back previous class if needed
	[editedclass release];
	editedclass=nil;
	if(rowIndex >= 0)
		{
		c=[self valueInClassTable:Content_Class_name row:rowIndex];	// get class name that was selected
		editedclass=[[classes objectForKey:c] retain];	// class object
		editedproperty=nil;	// no method initially selected
		}
	[propertylist reloadData];	// changed
}

- (void) selectClass:(NSString *) name
{ // select that class
	int r;
	r=[allClassKeys indexOfObject:name];	// locate
	NSLog(@"selectClass %@ -> %d", name, r);
	if(r == NSNotFound)
		{ // not in visible classes
		if([[classes allKeys] containsObject:name])
			{
        // change filter && [classlist reloadData]
			r=[allClassKeys indexOfObject:name];	// locate - should now be found
			}
		}
	[classlist selectDataRow:r byExtendingSelection:NO];
	[self showClass];
}

- (IBAction) editClass:(id) Sender
{
	[self showClass];
#if 0
	NSLog(@"NSApp mainWindow=%@", [NSApp mainWindow]);
	NSLog(@"NSApp keyWindow=%@", [NSApp keyWindow]);
#endif
	[classeditor makeKeyAndOrderFront:self];
#if 0
	NSLog(@"NSApp mainWindow=%@", [NSApp mainWindow]);
	NSLog(@"NSApp keyWindow=%@", [NSApp keyWindow]);
#endif
}

- (IBAction) deleteClass:(id) Sender
{
	int rowIndex=[classlist selectedDataRow];
	// [self saveClass:self];	// needn't save back that class
	if(rowIndex < 0)
		return;
		// only if it has no subclasses (?) and is an Application Class
	[self selectClass:nil];
	[self setValue:nil inClassTable:Content_Class_name row:rowIndex];
}

- (IBAction) duplicateClass:(id) Sender
{
	[self nimp];
}

- (IBAction) newMethod:(id) Sender	// may need to distinguish between newClassMethod and newInstanceMethod
{ // make new method
	int rowIndex=[classlist selectedDataRow];
	if(rowIndex < 0)
		return;		// ignore
	[self selectProperty:[self makeNewProperty:@"-MyMethod" forClass:[self valueInClassTable:Content_Class_name row:rowIndex] withType:@"" withArgs:@""]];
}

- (IBAction) newVariable:(id) Sender
{ // make new instance variable in selected class
	int rowIndex=[classlist selectedDataRow];
	if(rowIndex < 0)
		return;		// ignore
	[self selectProperty:[self makeNewProperty:@"MyVariable" forClass:[self valueInClassTable:Content_Class_name row:rowIndex] withType:@"" withArgs:@""]];
}

// actions (special methods)

- (IBAction) newAction:(id)Sender
{ // SUB myAction:(sender AS OBJECT)
	int rowIndex=[classlist selectedDataRow];
	if(rowIndex < 0)
		return;		// ignore
	[self selectProperty:[self makeNewProperty:@"-MyAction:" forClass:[self valueInClassTable:Content_Class_name row:rowIndex] withType:@"" withArgs:@"Sender AS Object"]];
}

// outlets (special instance variables)

- (IBAction) newOutlet:(id)Sender
{ // DIM myOutlet AS OUTLET Object
	int rowIndex=[classlist selectedDataRow];
	if(rowIndex < 0)
		return;		// ignore
	[self selectProperty:[self makeNewProperty:@"MyOutlet" forClass:[self valueInClassTable:Content_Class_name row:rowIndex] withType:@"OUTLET Object" withArgs:nil]];
}

- (IBAction) deleteProperty:(id) Sender
{
	int rowIndex=[propertylist selectedDataRow];
	if(rowIndex < 0)
		return;
#if 0
	if([self valueInPropertyTable:Content_Class_Method_source row:rowIndex] != nil)
		{ // source exists
		[self saveProperty:self];	// save back changes so that they don't interfere
		[self setValue:nil inPropertyTable:Content_Class_Method_source row:rowIndex];
		[self showProperty];		// and show changes
		return;
		}
#endif
	// [self saveProperty:self];	// needn't save back that class
	[self selectProperty:nil];	// deselect
	[self setValue:nil inPropertyTable:Content_Class_Property_type row:rowIndex];
}

- (IBAction) duplicateProperty:(id) Sender
{
	// copy
	// select
	[self nimp];
}

- (BOOL) isValidClassIdentifier:(NSString *) s;		// valid class name (alphanum, "%_$", no blanks)
{
	return YES;
}

- (BOOL) isValidPropertyIdentifier:(NSString *) s;	// variable, class or instance method (alphanum, "_", no blanks, methods begin with "+-", and have ":" as well)
{
	return YES;
}

- (BOOL) isValidInstanceIdentifier:(NSString *) s;	// valid instance name (any alphanum)
{
	return YES;
}

- (BOOL) isValidGroupIdentifier:(NSString *) s;		// valid NIB filename (any except " /:", may not begin with "~")
{
	return YES;
}

- (BOOL) isInstanceVariable:(NSString *) name
{
	return ![self isMethod:name];
}

- (BOOL) isClassMethod:(NSString *) name
{
	return [[name substringToIndex:1] isEqualToString:Content_Class_Property_typeCmethod];
}

- (BOOL) isInstanceMethod:(NSString *) name
{
	return [[name substringToIndex:1] isEqualToString:Content_Class_Property_typeImethod];
}

- (BOOL) isMethod:(NSString *) name
{
	return [self isClassMethod:name] || [self isInstanceMethod:name];
}

- (BOOL) property:(NSString *) name isDefinedInClass:(NSString *) cls
{
	NSDictionary *c;
	if(cls == nil)
		return NO;	// no superclass
	c=[classes objectForKey:cls];
	if(!c)
		return NO;	// superclass does not exist
	return [[c objectForKey:Content_Class_Properties] objectForKey:name] != nil;	// name exists in that class
}

- (IBAction) filterProperty:(id) Sender
{ // propertyfilter changed
#if 0
	NSLog(@"filterProperty");
#endif
	[propertylist reloadData];
}

- (void) saveProperty:(id) Sender
{ // save property changes
	if(editedPropertyNeedsSaving)
		{ // copy back
#if 0
		NSLog(@"editedpropery=%@", editedproperty);
		NSLog(@"saveProperty\nmethodname: %@\nmethodargs: %@\nsource: %@\n", [methodname stringValue], [methodargs stringValue], [codeeditor string]);
#endif
		[editedproperty setObject:[typename stringValue] forKey:Content_Class_Property_type];
		[editedproperty setObject:[methodargs stringValue] forKey:Content_Class_Method_args];
		[editedproperty setObject:[[[codeeditor string] copy] autorelease] forKey:Content_Class_Method_source];	// save snapshot ([... string] just returns a pointer to the internal buffer
		if([[sourcecode string] isEqualToString:@""])
			[editedproperty removeObjectForKey:Content_Class_Method_icode];
		else
			[editedproperty setObject:[[[sourcecode string] copy] autorelease] forKey:Content_Class_Method_icode];
		NSLog(@"editedpropery=%@", editedproperty);
		editedPropertyNeedsSaving=NO;	// done
		}
}

- (void) showProperty
{ // method or instance variable - called for class editor
	int rowIndex=[propertylist selectedDataRow];
	NSString *m;
	NSString *src;
	NSString *sc;
	BOOL cm;	// class method
	[self saveProperty:self];	// may need saving before selecting some other
	[editedproperty release];
	editedproperty=nil;
	if(rowIndex >= 0)
		{
		m=[self valueInPropertyTable:Content_Class_Property_name row:rowIndex];	// get name that was selected
		editedproperty=[[[editedclass objectForKey:Content_Class_Properties] objectForKey:m] retain];	// get selected property object
#if 0
		NSLog(@"show editedpropery(%@)=%@", m, editedproperty);
#endif
		[typename setObjectValue:[editedproperty objectForKey:Content_Class_Property_type]];	// copy
		cm=[self isClassMethod:m];
		if(cm || [self isInstanceMethod:m])
			{ // method
			[methodname setObjectValue:[m substringFromIndex:1]];	// name without prefix
			[methodargs setObjectValue:[editedproperty objectForKey:Content_Class_Method_args]];	// not a method
			[methodargs setEditable:YES];
			src=[editedproperty objectForKey:Content_Class_Method_source];
#if 1
			NSLog(@"source: %@", src);
#endif
			if(src == nil)
				{ // new method - create empty source frame
				if(cm)
					src=@"CLASS ";
				else
					src=@"";
				if(![[typename stringValue] isEqualToString:@""])
					src=[NSString stringWithFormat:@"%@FUNCTION %@", src, [methodname stringValue]];
				else
					src=[NSString stringWithFormat:@"%@SUB %@", src, [methodname stringValue]];
				if(![[methodargs stringValue] isEqualToString:@""])
					src=[NSString stringWithFormat:@"%@ (%@)", src, [methodargs stringValue]];
				if(![[typename stringValue] isEqualToString:@""])
					src=[NSString stringWithFormat:@"%@ AS %@\n  RETURN SUPER.%@(...)\nEND FUNCTION", src, [typename stringValue], [methodname stringValue]];
				else
					src=[NSString stringWithFormat:@"%@\n  SUPER.%@(...)\nEND SUB", src, [methodname stringValue]];
				}
			[codeeditor setEditable:YES];
			[codeeditor setString:src];	// copy
			[codeeditor highlightSyntax];
			sc=[editedproperty objectForKey:Content_Class_Method_icode];
			if(!sc)
				sc=@"";
#if 1
			NSLog(@"cocoa script code %@", sc);
#endif
			[sourcecode setString:sc];	// source code
			[objectcode reloadData];
			}
		else
			{ // Instance Variable
			[methodname setObjectValue:m];
			[methodargs setObjectValue:@""];	// not a method
			[methodargs setEditable:NO];
			[codeeditor setString:[NSString stringWithFormat:@"DIM %@ AS %@", m, [editedproperty objectForKey:Content_Class_Property_type]]];	// empty
			[codeeditor setEditable:NO];
			[sourcecode setString:@""];	// should have no source code!
			[objectcode reloadData];
			}
		}
}

- (void) selectProperty:(NSString *) name
{ // select that property
	int r;
	r=[allPropertyKeys indexOfObject:name];	// locate
	NSLog(@"selectProperty %@ -> %d", name, r);
	if(r == NSNotFound)
		{ // not in visible classes
		if([[[editedclass objectForKey:Content_Class_Properties] allKeys] containsObject:name])
			{
			// change filter && [classlist reloadData]
			r=[allPropertyKeys indexOfObject:name];	// locate - should now be found
			}
		}
	[propertylist selectDataRow:r byExtendingSelection:NO];
	[self showProperty];
}

#if 0
- (IBAction) editProperty:(id) Sender
{
	[self showProperty];
	//	[classeditor makeKeyAndOrderFront:self];	// should already be front!
}
#endif

// edit compiled code

- (IBAction) editCode:(id) Sender
{
#if 1
	NSLog(@"editCode");
#endif
	[classeditor makeKeyAndOrderFront:self];	// should already be front!
	[sourceeditor open:self];	// open drawer
}

- (IBAction) compileSource:(id) Sender
{ // compile current method source code to cocoascript source
	NSString *icode;
	[self saveProperty:Sender];
#if 1
	[self editCode:Sender];	// open
#endif
	NS_DURING	// set up exception handler!
		compiler=NSClassFromString(@"BasicCompiler");
		if(compiler == nil)
			[NSException raise:@"Build Error" format:@"Compiler plugin is not available"];
		icode=[compiler compile:[codeeditor string]];	// compile
		[sourcecode setString:icode];
		[editedproperty setObject:[sourcecode stringValue] forKey:Content_Class_Method_code];	// copy to current method
		[editedproperty removeObjectForKey:Content_Class_Method_code];	// no code (yet)
		editedPropertyNeedsSaving=YES;
		[self touch];			
	NS_HANDLER
		{ // exception, i.e. syntax error or alike
	//			[sourcecode setSelectedRange:NSMakeRange([compiler errorPos], 0)];	// show scanner location
			NSRunAlertPanel([localException name], @"%@", @"OK", nil, nil, localException);
		}
	NS_ENDHANDLER
}

- (IBAction) compileCode:(id) Sender
{ // compile current intermediate code to cocoascript
	NSData *code;
	HNSCocoaScript *cocoascript=[[[HNSCocoaScript alloc] init] autorelease];	// get a new one
	[cocoascript clearScript];
	NS_DURING	// set up exception handler!
		[cocoascript scanFromScanner:[NSScanner scannerWithString:[sourcecode string]]];
	NS_HANDLER
		{ // exception, i.e. syntax error or alike
		NSScanner *s=[cocoascript scanner];
		[sourcecode setSelectedRange:NSMakeRange([s scanLocation], 0)];	// show scanner location
		NSRunAlertPanel([localException name], @"%@", @"OK", nil, nil, localException);
		}
	NS_ENDHANDLER
	[editedproperty setObject:cocoascript forKey:Content_Class_Method_code];	// store new code
	[objectcode reloadData];	// and display new representation
	editedPropertyNeedsSaving=YES;
	[self touch];
	code=[NSArchiver archivedDataWithRootObject:cocoascript];	// convert to NSData
	NSLog(@"compiled code=%@", code);
}

- (IBAction) runCode:(id) Sender
{ // should append to script result???
	HNSCocoaScript *cocoascript=[editedproperty objectForKey:Content_Class_Method_code];
	if(cocoascript)
		{ // set up exception handler
		NS_DURING
			[scriptresult setString:[[cocoascript evaluate] description]];
		NS_HANDLER
			{ // runtime exception
			NSRunAlertPanel([localException name], @"%@", @"OK", nil, nil, localException);
			}
		NS_ENDHANDLER
		}
	else
		[scriptresult setString:@"No Code"];
}

// instances

- (IBAction) newInstance:(id) Sender
{
	NSString *class;
#if 0
	NSLog(@"new Instance");
#endif
	if([Sender action] == @selector(newWindow:))
		class=@"NSWindow";
	else if([Sender action] == @selector(newMenu:))
		class=@"NSMenu";
	else
		{ // standard newInstance
		if([classlist selectedRow] < 0)
			return;	// menu item should be disabled
		class=[self valueInClassTable:Content_Class_name row:[classlist selectedDataRow]];
		}
	[self selectInstance:[self makeNewInstanceForClass:class]];
	[self editInstance:self];		// and show
}

- (void) showInstance
{
	int rowIndex=[instancelist selectedDataRow];
	NSString *c;
	[editedinstance release];
	editedinstance=nil;
	if(rowIndex >= 0)
		{
		c=[self valueInInstanceTable:Content_Instances_name row:rowIndex];
		editedinstance=[[instances objectForKey:c] retain];	// reference to instance object
		// should show in Menu or Window editor, i.e. Menu&Window Editors should also have a reloadData method
		}
	[valuelist reloadData];	// has been changed
}

- (void) selectInstance:(NSString *) name
{ // select that instance
	int r;
	r=[allInstanceKeys indexOfObject:name];	// locate
	NSLog(@"selectInstance %@ -> %d", name, r);
	if(r == NSNotFound)
		{ // not in visible instances
		if([[instances allKeys] containsObject:name])
			{
			// change filter && [classlist reloadData]
			r=[allInstanceKeys indexOfObject:name];	// locate - should now be found
			}
		}
	[instancelist selectDataRow:r byExtendingSelection:NO];
	[self showInstance];
}

- (IBAction) editInstance:(id) Sender
{
	int rowIndex=[instancelist selectedDataRow];
	NSString *c;
	if(rowIndex < 0)
		return;		// ignore
	c=[self valueInInstanceTable:Content_Instances_Class row:rowIndex];
#if 1
	NSLog(@"editInstance class=%@", c);
#endif
//	if(([[NSApp currentEvent] modifierFlags] & NSAlternateKeyMask) != 0)
		{
		if([self isSubclass:c ofClass:@"NSWindow"])
			[self editWindow:self];
		else if([self isSubclass:c ofClass:@"NSMenu"])
			[self editMenu:self];
		}
	[self showInstance];
	[instanceeditor makeKeyAndOrderFront:self];
}

- (IBAction) deleteInstance:(id) Sender
{
	int rowIndex=[instancelist selectedDataRow];
	// [self saveInstance:self];	// needn't save back that class
	if(rowIndex < 0)
		return;
	[self selectInstance:nil];
	[self setValue:nil inInstanceTable:Content_Instances_name row:rowIndex];
}

- (IBAction) duplicateInstance:(id) Sender
{
	[self nimp];
}

// menus (special instances)

- (IBAction) newMenu:(id) Sender
{ // create new Menu
	[self newInstance:Sender];
}

- (IBAction) editMenu:(id) Sender
{ // copy selected entry
  // must be menu
	[menueditor makeKeyAndOrderFront:Sender];
}

// windows (special instances)

- (IBAction) newWindow:(id) Sender
{ // create new Window
	[self newInstance:Sender];
}

- (IBAction) editWindow:(id) Sender
{ // copy selected entry
  // must be window
	[windoweditor makeKeyAndOrderFront:Sender];
}

@end
